import QtQuick 1.1

Item {
    id: radioPage
    property bool toggleSpeaker: false
    property int i: 0

    function test()
    {
        console.log("radiopage test")
    }

//    MyButton {
//        y: 30
//        x: 300
//        width: 400
//        height: 200
//        text: "test button"
//        onClicked: {
//            text = fmRadio.testrds()
//            //text =  fmRadio.getSignalStrength()
//        }
//    }

    Rectangle{
        z: 100
        opacity: 0.5
        color: "black"
        visible: isHildon ? (fmRadio.active ? false : true) : false
        anchors {
            top: parent.top
            left:parent.left
            right: parent.right
            bottom: parent.bottom
        }
        MouseArea {
            anchors.fill: parent
        }
    }




    Label {
        id: radio
        x: isPortrait ? 50 : 450
        anchors.top: parent.top
        anchors.topMargin: 80
        anchors.left: parent.left
        anchors.leftMargin: 10
        text: "Radio:"
        font.pixelSize: 18
        height:  20
        color: "grey"
        MouseArea {
            anchors.fill: parent
           // onClicked: radioName.text = GlobalJS.currentStation
        }
    }
    Label {
        id: radiops
        text: fmRadio.ps
        width: isPortrait ? 450 : 350
        font.pixelSize: 18
        height:  20
        color: "grey"
        wrapMode: Text.WrapAtWordBoundaryOrAnywhere
        x: radio.x + 60
        y: radio.y
    }

    Label {
        color: "white"
        anchors.right: parent.right
        anchors.rightMargin: 10
        y: radio.y
        text: fmRadio.signalStrenght + "%"
    }



//    Label {
//        color: "gray"
//        x: isPortrait === "Portrait" ? 15 : 500
//        y: isPortrait === "Portrait" ? 70 : 120
//        text: "Program:"
//        font.underline: true
//        font.pixelSize: 18
//    }

//    Label {
//        text: fmRadio.rt
//        width: screen.orientationString === "Portrait" ? 450 : 350
//        wrapMode: Text.WrapAtWordBoundaryOrAnywhere
//        x: isPortrait === "Portrait" ? 15 : 500
//        y: isPortrait === "Portrait" ? 90 : 140
//    }

    FrequencyLabel {
        id: freqLab
        anchors.horizontalCenter: radioPage.horizontalCenter
        anchors.horizontalCenterOffset: isPortrait ? 0 : -200
        anchors.top: radio.bottom
        anchors.topMargin: isPortrait ? 20 : 10

        mhText: Math.floor(fmRadio.freq / 1000)
        khText: fmRadio.freq % 1000 === 0 ? "000" : Math.round(fmRadio.freq % 1000)
    }

    Row {
        id: quickAccessButtonsRow
        anchors.horizontalCenter: freqLab.horizontalCenter
        anchors.top: freqLab.bottom
        anchors.topMargin: 15

        spacing: 5

        QuickAccessButton {
            objectName: "QuickButton01"
            freqText: Settings.value(objectName, "99200")
            onClicked: fmRadio.freq = freqText
            onHold: {
                freqText = fmRadio.freq
                Settings.setValue(objectName, freqText)
            }
        }

        QuickAccessButton {
            objectName: "QuickButton02"
            freqText: Settings.value(objectName, "99200")
            onClicked: fmRadio.freq = freqText
            onHold: {
                freqText = fmRadio.freq
                Settings.setValue(objectName, freqText)
            }
        }

        QuickAccessButton {
            objectName: "QuickButton03"
            freqText: Settings.value(objectName, "99200")
            onClicked: fmRadio.freq = freqText
            onHold: {
                freqText = fmRadio.freq
                Settings.setValue(objectName, freqText)
            }
        }

        QuickAccessButton {
            objectName: "QuickButton04"
            freqText: Settings.value(objectName, "99200")
            onClicked: fmRadio.freq = freqText
            onHold: {
                freqText = fmRadio.freq
                Settings.setValue(objectName, freqText)
            }
        }
    }

    Row {
        id: favButtons
        anchors.right: buttonsGrid.right
        anchors.bottom: buttonsGrid.top
        anchors.bottomMargin: 5
        spacing: 5


        MyButton {
            width: 195
            text: "PREV"
            fontFamily: digital7Font.name
            onClicked: {
                playPrev()
            }
        }

        MyButton {
            width: 195
            text: "next"
            fontFamily: digital7Font.name
            onClicked: {
                playNext()
            }
        }

    }

    Grid {
        id: buttonsGrid
        anchors.horizontalCenter: radioPage.horizontalCenter
        anchors.bottom: radioPage.bottom
        anchors.bottomMargin: 15
        columns: isPortrait ? 2 : 4
        spacing: 5


        MyButton {
            width: 195
            text: "Freq down"
            fontFamily: digital7Font.name

            onClicked: {
                fmRadio.freqDown()
            }
        }

        MyButton {
            width: 195
            text: "freq up"
            fontFamily: digital7Font.name
            onClicked: {
                fmRadio.freqUp()
            }
        }

        MyButton {
            width: 195
            text: "scan down"
            fontFamily: digital7Font.name
            onClicked: {
                fmRadio.scanDown()
            }
        }

        MyButton {
            width: 195
            text: "scan up"
            fontFamily: digital7Font.name
            onClicked: {
                fmRadio.scanUp()
            }
        }

    }

    SleepTimer {
        id: sleepTimer
        visible: false

    }
}
