import QtQuick 1.1

Item {
    id: rec1
    z: 1
    anchors.fill: parent
    property alias stationName: stationNameField.text
    property int i: 0
    property bool editMode: false
    property int indexe: 0
    property bool fave: false
    onVisibleChanged: {
        if (visible == true)
            ++i
        stationNameField.forceActiveFocus()
    }
    MouseArea {
        anchors.fill: parent
        onClicked: rec1.visible = false
    }

    Item {
        z: 100
        y: parent.height / 5
        id: addStationSheet
        anchors.horizontalCenter: parent.horizontalCenter
        width: 430
        height: 150
        onVisibleChanged: stationNameField.forceActiveFocus()

        Rectangle {
            anchors.fill: addStationSheet
            color: "black"
            opacity: 0.5
            border.color: "white"
            radius: 4
        }
        Rectangle {
            anchors.fill: addStationSheet
            color: "transparent"
            opacity: 0.6
            border.color: "white"
            radius: 4
        }
        Rectangle {
            id: rectangle1
            width: 200
            height: 40
            y: 10
            anchors.horizontalCenter: parent.horizontalCenter
            color: "black"
            border.color: "white"
            radius: 8
            opacity: 0.15
        }
        TextEdit {
            id: stationNameField
            focus: true

            anchors.centerIn: rectangle1
            width: rectangle1.width
            text: "Station name"
            color: "white"
            font.pixelSize: 20
        }
            MyButton {
                text: "Ok"
                anchors {
                    bottom: parent.bottom
                    bottomMargin: 2
                    horizontalCenter: parent.horizontalCenter
                }

                onClicked: {
                    if(editMode == true)
                    {
                        stationsManager.updateStation(indexe, stationNameField.text,
                                                   fmRadio.freq, fave)
                    }
                    else {
                        stationsManager.addStation(stationNameField.text,
                                                   fmRadio.freq, "false")
                    }

                    rec1.visible = false
                }
            }
    }
}
