#ifndef FMRADIO_H
#define FMRADIO_H

#include <QtCore>
#include <QtDBus/QtDBus>

#include <QRadioTuner>
#include <qplatformdefs.h>

#include "v4lradiocontrol_maemo5.h"
#include <QSettings>
#include <QTextStream>
#include <QX11Info>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

const int autoScanTimerInterval = 2000;

class FMRadio : public QObject
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.qmlradio.control")
    Q_ENUMS(RadioState)

    Q_PROPERTY(bool active READ active WRITE setActive NOTIFY activeChanged)
    Q_PROPERTY(int freq READ freq WRITE setFreq NOTIFY freqChanged)
    Q_PROPERTY(int signalStrenght READ signalStrenght NOTIFY signalStrenghtChanged)
    Q_PROPERTY(QString rt READ rt NOTIFY rtChanged)
    Q_PROPERTY(QString ps READ ps NOTIFY psChanged)
    Q_PROPERTY(bool autoscanActive READ autoscanActive NOTIFY autoscanActiveChanged)
    Q_PROPERTY(float autoScanPercentage READ autoScanPercentage NOTIFY autoScanPercentageChanged)


public:
    explicit FMRadio(QObject *parent = 0);

    ~FMRadio();

    enum RadioState { ActiveState, StoppedState };

    Q_INVOKABLE void freqDown();
    Q_INVOKABLE void freqUp();
    Q_INVOKABLE void scanDown();
    Q_INVOKABLE void scanUp();

    Q_INVOKABLE void startAutoScan();

    Q_INVOKABLE QString testrds();
    Q_INVOKABLE void toggleSpeaker();


    void setFreq(int value);
    int signalStrenght();
    QString rt();
    QString ps();
    bool autoscanActive();
    float autoScanPercentage();
    RadioState radioState();
    
signals:
    void activeChanged();
    void freqChanged();
    void signalStrenghtChanged();
    void rtChanged();
    void psChanged();
    void autoscanActiveChanged();
    void autoScanPercentageChanged();
    void doNext();
    void doPrev();

    void scannedStationFound(int freq, QString name);
    
public slots:
    void next();
    void prev();
    void setActive(bool value = true);
    bool active();
    int freq();


private:
    V4LRadioControl *radioTuner;

    bool m_active;
    int m_freq;
    int m_signalStrenght;
    QString m_ps;
    QString m_rt;
    bool m_autoscanActive;
    float m_autoScanPercentage;
    RadioState m_radioState;
    bool isHildon;
    bool isCallActive;

    QString headphoneStatus;
    QTimer autoScanTimer;
    bool isSpeaker;
    int latestFreq;
    int speakerVolume;

private slots:
    void radioFreqChanged(int freq);
    void processSignal(int newSignal);

    void restoreMic();
    void callIncoming();
    void callEnded();

    void newRadioTuner();

    void onHeadphoneChanged(const QString &msg1, const QString &msg2);   

    QString getRDS_ps();
    QString getRDS_rt();

    void sendStatus(const int &status);
    void sendFreq();
    void volumeChangedSlot(const QDBusMessage &msg);
    void setVolume();
    bool headphoneConnected();

};

#endif // FMRADIO_H
