#include "bluetoothheadsetadapter.h"

BluetoothHeadsetAdapter::BluetoothHeadsetAdapter(QObject *parent) :
    QObject(parent)
{
    QDBusConnection::systemBus().connect( QString(),
                                          QString(),
                                          "org.freedesktop.Hal.Device",
                                          "Condition",
                                          this, SLOT(processBTSignal(QString, QString)));
}

void BluetoothHeadsetAdapter::processBTSignal(QString event, QString state)
{
    qDebug() << "BT Button pressed";
    QTime t = QTime::currentTime();

    long msec = _time.msecsTo(t);

    if (msec > _DBUS_ACTION_TIMEOUT_)
    {
        if (event == "ButtonPressed")
        {
            if (state == "next-song")
            {
                qDebug()<<"next button pressed";
                emit nextButtonPressed();
            }
            else if (state == "previous-song")
            {
                qDebug()<<"prev button pressed";
                emit prevButtonPressed();
            }
            else if (state == "play-cd" || state == "pause-cd")
            {
                qDebug()<<"toggle button pressed";
                emit toggleButtonPressed();
            }
            else if (state == "connection")
            {
                qDebug()<<"Connection Bluetooth State";
                 bool present = QDBusInterface ("org.freedesktop.Hal",
                                                "/org/freedesktop/Hal/devices/platform_headphone",
                                                "org.freedesktop.Hal.Device",
                                                QDBusConnection::systemBus()).call ("GetProperty", "button.state.value").arguments().at(0).toBool();
                 if (!present)
                 {
                       //pause();
                       qDebug()<<"Pause";
                 }
                 else
                 {
                     QTimer::singleShot(1000, this, SLOT(playIfPaused()));
                     qDebug()<<"PlayIfPaused";
                 }

             }
         }
     }
            _time = t;
}
