#ifndef RADIO_H
#define RADIO_H

#include <QtCore>
#include <QObject>
#include <QRadioTuner>

class Radio : public QObject
{
    Q_OBJECT
public:
    explicit Radio(QObject *parent = 0);
    ~Radio();

public slots:
    void startRadio();
    void stopRadio();
    bool isRadioActive();
    bool isHeadphoneConnected();
    void setFreq(QString freq);
    QString getFreq();


signals:
    void freqChanged(QString);

public slots:
    Q_INVOKABLE void scanUp();
    Q_INVOKABLE void scanDown();
    Q_INVOKABLE void freqUp();
    Q_INVOKABLE void freqDown();

private:
    QRadioTuner* radioTuner;

private slots:
    void onFreqChanged(int);

};

#endif // RADIO_H
