#include "radio.h"

Radio::Radio(QObject *parent) :
    QObject(parent)
{
    radioTuner = 0;


}

Radio::~Radio()
{
    stopRadio();
}

void Radio::onFreqChanged(int freq)
{
    freq /= 1000;
    emit freqChanged(QString::number(freq, 'f', 0));
}

void Radio::scanUp()
{
    radioTuner->searchForward();
}

void Radio::scanDown()
{
    radioTuner->searchBackward();
}

void Radio::freqUp()
{
    int f = radioTuner->frequency();
    f = f + radioTuner->frequencyStep(QRadioTuner::FM);
    radioTuner->setFrequency(f);
    qDebug() << "Freq Up";
}

void Radio::freqDown()
{
    int f = radioTuner->frequency();
    f = f - radioTuner->frequencyStep(QRadioTuner::FM);
    radioTuner->setFrequency(f);
}

void Radio::startRadio()
{

    if ( !isHeadphoneConnected() )
    {
        qDebug()<<"No headphones found, returning.";
        return;
    }

    radioTuner = new QRadioTuner;
    connect(radioTuner, SIGNAL(frequencyChanged(int)), this, SLOT(onFreqChanged(int)));

}

bool Radio::isRadioActive()
{
    return radioTuner;
}

bool Radio::isHeadphoneConnected()
{
    QFile file("/sys/devices/platform/gpio-switch/headphone/state");
    file.open(QIODevice::ReadOnly | QIODevice::Text);
    QTextStream t( &file );
    QString headphoneStatus;
    headphoneStatus = t.readLine();
    qDebug()<<"Headphone status: "<<headphoneStatus;
    file.close();

    if (headphoneStatus == "disconnected")
    {
        return false;
    }
    else
    {
        return true;
    }
}

void Radio::stopRadio()
{
    delete radioTuner;
    radioTuner=0;
}

void Radio::setFreq(QString freq)
{
    int freqNumber = freq.toDouble() * 1000000;
    radioTuner->setFrequency(freqNumber);
}

QString Radio::getFreq()
{
    double freq = radioTuner->frequency();
    freq /= 1000000;
    return QString::number(freq, 'd', 3);
}
