import QtQuick 1.0
import QtWebKit 1.0
import org.hildon.components 1.0

Item {
    id: root

    property alias url: view.url
    property alias title: view.title
    property alias icon: view.icon
    property alias javaScriptWindowObjects: view.javaScriptWindowObjects
    property alias newWindowComponent: view.newWindowComponent
    property alias newWindowParent: view.newWindowParent
    property alias preferredHeight: view.preferredHeight
    property alias preferredWidth: view.preferredWidth
    property alias pressGrabTime: view.pressGrabTime
    property alias back: view.back
    property alias forward: view.forward
    property alias reload: view.reload
    property alias stop: view.stop
    property alias progress: view.progress
    property alias interactive: flicker.interactive
    property alias moving: flicker.moving

    signal loadStarted
    signal loadFinished
    signal loadFailed
    signal urlChanged

    anchors.fill: !parent ? undefined : parent

    Keys.onPressed: {
        if (event.key === Qt.Key_Up) {
            if (event.modifiers & Qt.ShiftModifier) {
                flicker.contentY = 0;
            }
            else if (!flicker.atYBeginning) {
                flicker.contentY -= 20;
            }
        }
        else if (event.key === Qt.Key_Down) {
            if (event.modifiers & Qt.ShiftModifier) {
                flicker.contentY = (flicker.contentHeight - flicker.height);
            }
            else if (!flicker.atYEnd) {
                flicker.contentY += 20;
            }
        }
        else if ((event.key === Qt.Key_Left) && (!flicker.atXBeginning)) {
            flicker.contentX -= 20;
        }
        else if ((event.key === Qt.Key_Right) && (!flicker.atXEnd)) {
            flicker.contentX += 20;
        }
        else if ((event.modifiers & Qt.ControlModifier) && (event.key === Qt.Key_R)) {
            view.reload.trigger();
        }
        else if ((event.modifiers & Qt.ShiftModifier) && (root.state == "panning_mode_on")) {
            root.state = "panning_mode_shift";
        }
        else if (event.key === Qt.Key_Space) {
            dragMouseArea.click();
        }
    }

    Keys.onReleased: if ((event.modifiers & Qt.ShiftModifier) && (root.state == "panning_mode_on_shift")) root.state = "";

    MouseArea {
        id: dragMouseArea

        anchors {
            left: mouseArea.right
            right: parent.right
            top: parent.top
            bottom: parent.bottom
        }
        enabled: false
        drag.target: mousePointer
        drag.filterChildren: true
        onPressed: {
            mousePointer.x = mouseX;
            mousePointer.y = mouseY;
            loader.sourceComponent = panningIndicator;
        }
        onReleased: if (root.state == "panning_mode_on") root.state = "";
        onContainsMouseChanged: console.log(containsMouse)

        Flickable {
            id: flicker

            anchors.fill: parent
            contentWidth: view.contentsSize.width
            contentHeight: view.contentsSize.height
            interactive: true

            WebView {
                id: view

                anchors.fill: parent
                onLoadStarted: root.loadStarted()
                onLoadFinished: root.loadFinished()
                onLoadFailed: root.loadFailed()
                onUrlChanged: root.urlChanged()
                pressGrabTime: 600000
            }
        }

        ScrollDecorator {
            flickableItem: flicker
        }
    }

    MouseArea {
        id: mouseArea

        property int xPos

        width: 5
        anchors {
            left: parent.left
            top: parent.top
            bottom: parent.bottom
        }
        onPressed: xPos = mouseX
        onMouseXChanged: if (mouseX - xPos > 3) root.state = "panning_mode_on";
    }

    Image {
        id: mousePointer

        //        source: "/usr/share/icons/hicolor/64x64/hildon/browser_panning_mode_off.png"
        source: "image://theme/icon/widgets_tickmark_list"
        visible: false
    }

    Loader {
        id: loader

        anchors {
            left: parent.left
            leftMargin: -8
            bottom: parent.bottom
            bottomMargin: (appWindow.fullScreen) || (view.progress < 1) ? 90 : 20
        }
    }

    Component {
        id: panningIndicator

        Item {
            width: 72
            height: 64

            Rectangle {
                anchors.fill: parent
                color: "black"
                opacity: 0.5
                radius: 5
            }

            Image {
                source: root.state == "panning_mode_on_locked" ? "image://theme/icon/widgets_tickmark_list"
                                                               : "image://theme/icon/general_close"
                //                source: root.state == "panning_mode_on_locked" ? "/usr/share/icons/hicolor/64x64/hildon/browser_panning_mode_on.png"
                //                                                               : "/usr/share/icons/hicolor/64x64/hildon/browser_panning_mode_off.png"
                anchors {
                    right: parent.right
                    verticalCenter: parent.verticalCenter
                }
            }

            MouseArea {
                anchors.fill: parent
                onClicked: root.state == "panning_mode_on_locked" ? root.state = ""
                                                                  : root.state = "panning_mode_on_locked"
            }
        }
    }

    Timer {
        interval: 3000
        running: (loader.sourceComponent == panningIndicator) && (!dragMouseArea.pressed) && (root.state !== "panning_mode_on_locked")
        onTriggered: loader.sourceComponent = undefined
    }

    states: [
        State {
            name: "panning_mode_on"
            PropertyChanges { target: flicker; interactive: false }
            PropertyChanges { target: dragMouseArea; enabled: true }
            AnchorChanges { target: dragMouseArea; anchors.left: parent.left }
            PropertyChanges { target: mousePointer; visible: true }
        },

        State {
            name: "panning_mode_shift"
            extend: "panning_mode_on"
            PropertyChanges { target: view; pressGrabTime: 0 }
        },

        State {
            name: "panning_mode_on_locked"
            extend: "panning_mode_on"
            PropertyChanges { target: view; pressGrabTime: 0 }
        }
    ]
}
