#ifndef WIDGET_H
#define WIDGET_H

#include <QWidget>
#include <QPushButton>
#include <gst/gst.h>
#include <pulse/pulseaudio.h>
#include <QtDBus>
#include <QDBusMessage>
#include <QLabel>
#include <QSlider>
#include <QtConcurrentRun>
#include "freqwidget.h"

class Widget : public QWidget
{
    Q_OBJECT
    
public:
    Widget(QWidget *parent = 0);
    ~Widget();

    GstElement *pipeline;
    GstElement *source;
    bool megaphoneActive;
    bool transmitterActive;
    QPushButton *button1;
    QPushButton *button2;
    QPushButton *freqLabel;
    QSlider *volumeSlider;
    FreqWidget *freqWidget;
    int lastVolumeValue;
    uint _freq;

private slots:
    void toggleMegaphone();
    bool enableMegaphone();
    bool disableMegaphone();
    void toggleTransmitter();
    void onTransmitterChanged(QString, const QString &msg2, QStringList);
    void callIncoming();
    void setFreqLabel(const uint &freq);
    void setVolume(const int &percent);
    void setVolumeThread(const int &percent);
    void onVolumeSliderChanged(const int &value);
    void getFreqRange(uint &freq_min,  uint &freq_max);
    void setFrequency(const uint &freq);
    void onFreqLabelClicked();
    void onFMTxPropChanged();
    QVariant getFMTxProperties(const QString &prop);
    void setFMTxProperties(const QString &prop, const QDBusVariant &value);

};

#endif // WIDGET_H
