#ifndef WIDGET_H
#define WIDGET_H

#include <QWidget>
#include <QPushButton>
#include <gst/gst.h>
#include <pulse/pulseaudio.h>
#include <QtDBus>
#include <QDBusMessage>
#include <QLabel>

class Widget : public QWidget
{
    Q_OBJECT
    
public:
    Widget(QWidget *parent = 0);
    ~Widget();

    GstElement *pipeline;
    bool megaphoneActive;
    bool transmitterActive;
    QPushButton *button1;
    QPushButton *button2;
    QLabel *freqLabel;

private slots:
    void toggleMegaphone();
    bool enableMegaphone();
    bool disableMegaphone();
    void enableTransmitter();
    void disableTransmitter();
    void toggleTransmitter();
    void onTransmitterChanged(QString, const QString &msg2, QStringList);
    void callIncoming();
    uint getFrequency();
    void setFreqLabel();

};

#endif // WIDGET_H
