/*
 *  qnotification.cpp
 *  author: Timo Härkönen
 */

#include "qnotification.h"
#include "qnotification_p.h"
#include "moc_qnotification.cpp"

namespace Maemo {

QNotifications::QNotifications(QObject *parent) :
    QObject(parent)
{
    MAEMO_INITIALIZE(QNotifications);
}

QNotifications::~QNotifications()
{
    MAEMO_UNINITIALIZE(QNotifications);
}

void QNotifications::showBanner(const QString &text)
{
    MAEMO_PRIVATE(QNotifications);
    priv->showBanner(text);
}

void QNotifications::showSystemNote(const QString &text)
{
    MAEMO_PRIVATE(QNotifications);
    priv->showSystemNote(text);
}

} //namespace
