#ifndef QHILDONNOTIFICATIONS_GLOBAL_H
#define QHILDONNOTIFICATIONS_GLOBAL_H

#if defined(QHILDONNOTIFICATIONS_LIBRARY)
#  define QHILDONNOFICATIONS_SHARED_EXPORT Q_DECL_EXPORT
#else
#  define QHILDONNOTIFICATIONS_SHARED_EXPORT Q_DECL_IMPORT
#endif

#endif //QHILDONNOTIFICATIONS_GLOBAL_H

#ifndef QHILDONSYSTEMCAPABILITIES_GLOBAL_H
#define QHILDONSYSTEMCAPABILITIES_GLOBAL_H

#if defined(QHILDONSYSTEMCAPABILITIES_LIBRARY)
#  define QHILDONSYSTEMCAPABILITIES_SHARED_EXPORT Q_DECL_EXPORT
#else
#  define QHILDONSYSTEMCAPABILITIES_SHARED_EXPORT Q_DECL_IMPORT
#endif

#endif //QHILDONSYSTEMCAPABILITIES_GLOBAL_H

#ifndef QHILDONWIDGETCAPABILITIES_GLOBAL_H
#define QHILDONWIDGETCAPABILITIES_GLOBAL_H

#include <QtCore/qglobal.h>

#if defined(QHILDONWIDGETCAPABILITIES_LIBRARY)
#  define QHILDONWIDGETCAPABILITIES_SHARED_EXPORT Q_DECL_EXPORT
#else
#  define QHILDONWIDGETCAPABILITIES_SHARED_EXPORT Q_DECL_IMPORT
#endif

//PRIVATE IMPLEMENTATION
#define MAEMO_DECLARE_PRIVATE(Class) \
        private: \
                inline Class##Private* priv_func() { return reinterpret_cast<Class##Private *>(priv_ptr); } \
                inline const Class##Private* priv_func() const { return reinterpret_cast<const Class##Private *>(priv_ptr); } \
                friend class Class##Private; \
                void* priv_ptr;

#define MAEMO_DECLARE_PUBLIC(Class) \
        public: \
                inline Class* pub_func() { return static_cast<Class *>(pub_ptr); } \
                inline const Class* pub_func() const { return static_cast<const Class *>(pub_ptr); } \
        private: \
                friend class Class; \
                void* pub_ptr;

#define MAEMO_PRIVATE(Class) Class##Private * const priv = priv_func();
#define MAEMO_PRIVATE_CONST(Class) const Class##Private * const priv = priv_func();
#define MAEMO_PUBLIC(Class) Class * const pub = pub_func();

#define MAEMO_INITIALIZE(Class) \
                priv_ptr = new Class##Private(); \
                MAEMO_PRIVATE(Class); \
                priv->pub_ptr = this;

#define MAEMO_UNINITIALIZE(Class) do { MAEMO_PRIVATE(Class); delete priv; } while(0)

#define compilation_assert(const_expr) do {switch(0){case 0: case const_expr: ; }} while(0)

#endif // QHILDONWIDGETCAPABILITIES_GLOBAL_H
