// checksum 0xfd0b version 0x20001
/*
  This file was generated by the Mobile Qt Application wizard of Qt Creator.
  MainWindow is a convenience class containing mobile device specific code
  such as screen orientation handling.
  It is recommended not to modify this file, since newer versions of Qt Creator
  may offer an updated version of it.
*/

#include "mainwindow.h"
#include "maemoinstructionswindow.h"
#include <QStringList>
#include <QFile>
#include <QTextStream>
#include <QProcess>
#include <QMessageBox>
#include <QApplication>




#include <QtCore/QCoreApplication>



MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{

    createCentralWidget();
    centralWidget->adjustSize();
    setCentralWidget(centralWidget);

    createStackedWidgets();
    stackedWidget->setFixedWidth(760);
    createCategories();

    createActions();
    createMenu();

    QString instructions(tr("This program uses two text files to dinamically set its layout.\n"
                            "To edit those files, just tap on the relative menu actions. \n"
                            "\n"
                            "Widgets file manages how many stacked widgets are gonna be shown.\n"
                            "Just insert a line with the widget name to make a new one.\n"
                            "\n"
                            "Categories file is rensponsible to create the sub-categories each widget is gonna have. \n"
                            "To insert a new category follow this rule:\nFirst line is the category name;\nSecond line is the widget the category belongs;\nThird line must hold true or false, if the category title must count all the items it contains pick true, otherwise false; \nFourth line is the number of the items the category have; \nFifth line and so on will be filled with each item names. \nIn the end there must be an empty line to divide each category from the other ones. \n"
                            "\n"
                            "There can't be stacked windows with same name, or categories with same name or same items."));
    instructionsWindow = new MaemoInstructionsWindow(this, instructions);
    instructionsWindow->setWindowTitle(tr("QInventory"));

    setAttribute(Qt::WA_Maemo5StackedWindow);
    setWindowTitle("QInventory");


}

MainWindow::~MainWindow()
{

}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#ifdef Q_OS_SYMBIAN
    if (orientation != ScreenOrientationAuto) {
#if defined(ORIENTATIONLOCK)
        const CAknAppUiBase::TAppUiOrientation uiOrientation =
                (orientation == ScreenOrientationLockPortrait) ? CAknAppUi::EAppUiOrientationPortrait
                    : CAknAppUi::EAppUiOrientationLandscape;
        CAknAppUi* appUi = dynamic_cast<CAknAppUi*> (CEikonEnv::Static()->AppUi());
        TRAPD(error,
            if (appUi)
                appUi->SetOrientationL(uiOrientation);
        );
        Q_UNUSED(error)
#else // ORIENTATIONLOCK
        qWarning("'ORIENTATIONLOCK' needs to be defined on Symbian when locking the orientation.");
#endif // ORIENTATIONLOCK
    }
#elif defined(Q_WS_MAEMO_5)
    Qt::WidgetAttribute attribute;
    switch (orientation) {
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_Maemo5PortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_Maemo5LandscapeOrientation;
        break;
    case ScreenOrientationAuto:
    default:
        attribute = Qt::WA_Maemo5AutoOrientation;
        break;
    }
    setAttribute(attribute, true);
#else // Q_OS_SYMBIAN
    Q_UNUSED(orientation);
#endif // Q_OS_SYMBIAN
}

void MainWindow::showExpanded()
{
#ifdef Q_OS_SYMBIAN
    showFullScreen();
#elif defined(Q_WS_MAEMO_5) || defined(Q_WS_MAEMO_6)
    showMaximized();
#else
    show();
#endif
}

void MainWindow::createStackedWidgets()
{
    QString path;

#ifdef Q_WS_MAEMO_5
    path="/home/user/.qinventory/widgets.txt";
#endif

    QFile file(path);
    file.open(QIODevice::ReadOnly | QIODevice::Text);
    QString line;
    QTextStream t( &file );

    QStringList lista;

    while (!t.atEnd())

    {
         line = t.readLine();
         lista.append(line);

    }



    file.close();


    widgetsList = new QList<QWidget *>;
    layoutsList = new QList<QVBoxLayout *>;
    widgetsNames = new QStringList;


    widgetsComboBox->insertItems(0, lista);
    connect(widgetsComboBox, SIGNAL(currentIndexChanged(int)), stackedWidget, SLOT(setCurrentIndex(int)));

    for (int i=0; i<lista.size(); i++)
    {

        scrollArea = new QScrollArea;
        QWidget *widget = new QWidget;

        QVBoxLayout *layout = new QVBoxLayout;
        widget->setLayout(layout);
        widget->setFixedWidth(750);



        scrollArea->setWidget(widget);
        stackedWidget->addWidget(scrollArea);

        widgetsList->append(widget);
        layoutsList->append(layout);
        widgetsNames->append(lista.at(i));







    }


}

void MainWindow::createCentralWidget()
{



    widgetsComboBox = new QComboBox;

    stackedWidget = new QStackedWidget;
   // stackedWidget->setFixedWidth(800);

    QVBoxLayout *mainLayout = new QVBoxLayout;
    mainLayout->addWidget(widgetsComboBox);
    mainLayout->addWidget(stackedWidget);



    centralWidget = new QWidget;
    centralWidget->setLayout(mainLayout);
}

void MainWindow::createCategories()
{
    categoriesList = new QList<Category *>;
    QString path;

#ifdef Q_WS_MAEMO_5
    path="/home/user/.qinventory/categories.txt";
#endif

    QFile file(path);
    file.open(QIODevice::ReadOnly | QIODevice::Text);
    QString line;
    QTextStream t( &file );

    while (!t.atEnd())

    {
         QString title;
         QString parent;
         int index;
         int items;
         bool showTot;
         QStringList lista;

         line = t.readLine();
         title = line;

         //std::cout<<title.toStdString();

         line = t.readLine();
         parent = line;

         line = t.readLine();
         if (line=="true") showTot=true;
         if (line=="false") showTot=false;

         line = t.readLine();
         items=line.toInt();

         for (int i=0; i<items; i++)
         {
             lista.append(line = t.readLine());
         }

         for (int i=0; i<widgetsNames->size(); i++)
         {
             if (parent == widgetsNames->at(i)) index=i;
         }

         Category *cat = new Category(this, title, showTot, lista);
         cat->adjustSize();
         layoutsList->at(index)->addWidget(cat);
         categoriesList->append(cat);

         line = t.readLine();

    }

    file.close();


    for (int i=0; i<widgetsList->size(); i++)
    {
        widgetsList->at(i)->adjustSize();
    }

}

void MainWindow::createActions()
{
    instructionsAction = new QAction(tr("Instructions"), this);
    connect(instructionsAction, SIGNAL(triggered()), SLOT(on_instructionsAction_clicked()));

    resetAction = new QAction(tr("Reset Values"), this);
    connect(resetAction, SIGNAL(triggered()), SLOT(on_resetAction_clicked()));

    editWidgetsAction = new QAction(tr("Edit Stacked Widgets"), this);
    connect(editWidgetsAction, SIGNAL(triggered()), SLOT(on_editWidgetsAction_clicked()));

    editCategoriesAction = new QAction(tr("Edit Categories"), this);
    connect(editCategoriesAction, SIGNAL(triggered()), SLOT(on_editCategoriesAction_clicked()));

    aboutQtAction = new QAction(tr("About Qt"), this);
    connect(aboutQtAction, SIGNAL(triggered()), SLOT(on_aboutQtAction_clicked()));

    aboutAction = new QAction(tr("About"), this);
    connect(aboutAction, SIGNAL(triggered()), SLOT(on_aboutAction_clicked()));
}

void MainWindow::createMenu()
{
    QMenu *menu;
    menu = menuBar()->addMenu(tr("MENU TITLE"));
    menu->addAction(instructionsAction);
    menu->addAction(resetAction);
    menu->addAction(editWidgetsAction);
    menu->addAction(editCategoriesAction);
    menu->addAction(aboutQtAction);
    menu->addAction(aboutAction);
}

void MainWindow::on_instructionsAction_clicked()
{

    instructionsWindow->show();


}

void MainWindow::on_aboutAction_clicked()
{
    QMessageBox::about(this, tr("About QInventory"),
                tr("<h2>QInventory 0.0.2</h2>"
                   "<p>"
                   "<p>Written by Giovanni Grammatico (ggiovanni88@yahoo.it)"));
}

void MainWindow::on_aboutQtAction_clicked()
{
    QApplication::aboutQt();
}

void MainWindow::on_editCategoriesAction_clicked()
{
    QProcess process;
    process.execute("leafpad /home/user/.qinventory/categories.txt");
}

void MainWindow::on_editWidgetsAction_clicked()
{
    QProcess process;
    process.execute("leafpad /home/user/.qinventory/widgets.txt");
}

void MainWindow::on_resetAction_clicked()
{
    int ret = QMessageBox::question(this, tr("QInventory"),
                                    tr("Are you sure?"),
                                    QMessageBox::Yes | QMessageBox::Cancel);

    switch (ret) {
       case QMessageBox::Yes:

        for (int i=0; i<categoriesList->size(); i++)
        {
            categoriesList->at(i)->reset();
        }

           break;
       case QMessageBox::Cancel:
           // Cancel was clicked
           break;
       default:
           // should never be reached
           break;
     }


}
