/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "application.h"
#include <qimsysserver.h>
#include <qimsyspluginmanager.h>
#include <qimsysdebug.h>
#include <translator.h>

#include <QDir>
#include <QIcon>
#include <QLibraryInfo>
#include <QStringList>
#include <QWidget>

class Application::Private : private QObject
{
    Q_OBJECT
public:
    Private(Application *parent);
    ~Private();

private:
    void setPluginPath();

private:
    Application *q;
};

Application::Private::Private(Application *parent)
    : QObject(parent)
    , q(parent)
{
    qimsysDebugIn() << parent;
    q->setOrganizationName("LinuxLife");
    q->setOrganizationDomain("linux-life.net");
    q->setApplicationName("qimsys");
    q->setApplicationVersion("0.1.0");

    QIcon icon;
    QDir icons(":/icons/");
    foreach(const QString &png, icons.entryList(QStringList() << "qimsys_*x*.png")) {
        icon.addPixmap(icons.absoluteFilePath(png));
    }
    q->setWindowIcon(icon);

    setPluginPath();

    QStringList confDir;
    confDir << QDir::homePath();
    confDir << QLatin1String(".config");
    confDir << QCoreApplication::organizationName();
    confDir << QCoreApplication::applicationName();
    QDir dir(confDir.join("/"));
    if (!dir.exists()) {
        dir.mkpath(dir.absolutePath());
    }
    Translator::installTranslator(QLatin1String("qt_"), QLibraryInfo::location(QLibraryInfo::TranslationsPath));
    Translator::installTranslator(QLatin1String("qimsys_"), q->applicationDirPath() + QLatin1String("/") + QIMSYS_MACRO_TO_STRING(QIMSYS_TRANSLATIONS_PATH));
//    QSettings settings;
//    settings.beginGroup("Application");
//    QString lang = settings.value("Language", tr("en_US")).toString();
//    Translator::setLanguage(lang);
    q->setQuitOnLastWindowClosed(false);

    new QimsysServer(this);
    qimsysDebugOut();
}

Application::Private::~Private()
{
    qimsysDebugIn();
    qimsysDebugOut();
}

void Application::Private::setPluginPath()
{
//    qimsysDebugOn();
    qimsysDebugIn();

#ifdef QIMSYS_APPLICATION_DIR_PATH
    QDir rootDir(QIMSYS_MACRO_TO_STRING2(QIMSYS_APPLICATION_DIR_PATH));
#else
    QDir rootDir = QApplication::applicationDirPath();
#endif
    // up to root dir
    for (int i = 0; i < QString(QIMSYS_MACRO_TO_STRING(QIMSYS_APP_PATH)).count(QLatin1Char('/')) + 1; i++) {
        rootDir.cdUp();
    }

    rootDir.cd(QLatin1String(QIMSYS_MACRO_TO_STRING(QIMSYS_PLUGIN_PATH)));

    qimsysDebug() << rootDir.absolutePath();
    setQimsysPluginPath(rootDir.absolutePath());
#ifndef Q_WS_X11
    if (rootDir.exists(QLatin1String("inputmethods"))) {
        q->addLibraryPath(rootDir.absolutePath());
    }
#endif
    qimsysDebugOut();
//    qimsysDebugOff();
}

Application::Application(int &argc, char **argv)
    : QApplication(argc, argv)
{
    if (!qgetenv("QIMSYS_DEBUG").isEmpty()) {
        qimsysDebugOn();
    }
    qimsysDebugIn();
    d = new Private(this);
    qimsysDebugOut();
}

Application::~Application()
{
    qimsysDebugIn();
    delete d;
    qimsysDebugOut();
}

#include "application.moc"
