/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "n900object.h"
#include "n900.h"
#include "n900settings.h"
#include "translator.h"

class N900Object::Private : private QObject
{
    Q_OBJECT
public:
    Private(N900Object *parent);
    ~Private();

    QimsysSettingsWidget *settings(const QString &hint, QWidget *parent = 0);

private slots:
    void enabledChanged(bool enabled);
    void saved();

private:
    N900Object *q;
    N900 *editor;
};

N900Object::Private::Private(N900Object *parent)
    : QObject(parent)
    , q(parent)
    , editor(0)
{
    q->setGroups(QStringList() << QLatin1String("X11 Classic"));
    q->setCategoryType(MoreThanOne);
    TR(q, "categoryName", this,  QT_TR_NOOP("User Interface/System Controler"));
    TR(q, "name", this, QT_TR_NOOP("Tool Bar"));
    TR(q, "author", this, QT_TR_NOOP("Tasuku Suzuki"));
    TR(q, "translator", this, QT_TR_NOOP("None"));
    connect(q, SIGNAL(enabledChanged(bool)), this, SLOT(enabledChanged(bool)), Qt::QueuedConnection);
    enabledChanged(q->isEnabled());
}

N900Object::Private::~Private()
{
    delete editor;
}

void N900Object::Private::enabledChanged(bool enabled)
{
    if (enabled && !editor) {
        editor = new N900(q);
    } else if (!enabled && editor) {
        delete editor;
        editor = 0;
    }
}

QimsysSettingsWidget *N900Object::Private::settings(const QString &hint, QWidget *parent)
{
    N900Settings *settings = new N900Settings(q, parent);
    connect(settings, SIGNAL(saved()), this, SLOT(saved()));
    return settings;
}

void N900Object::Private::saved()
{
    if (!editor) return;
    editor->settingsUpdated();
}

N900Object::N900Object(QObject *parent)
    : QimsysAbstractPluginObject(parent)
{
    d = new Private(this);
}

N900Object::~N900Object()
{
    delete d;
}

QimsysSettingsWidget *N900Object::settings(const QString &hint, QWidget *parent)
{
    return d->settings(hint, parent);
}

#include "n900object.moc"
