/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef SOCIALIME_H
#define SOCIALIME_H

#include "qimsysengine.h"

class SocialIME : public QimsysEngine
{
    Q_OBJECT
public:
    SocialIME(QObject *parent = 0);
    ~SocialIME();

    QString identifier() const;

public slots:
    void setRawString(const QString &rawString);
    void setInputString(const QString &inputString);
    void convert();
    void resize(int index, int delta);
    void commit(const QimsysConversionItemList &conversions);

public:
    QimsysConversionItemList candidates(int index);
    QimsysSettingsWidget *settings(const QString &hint, QWidget *parent);


private:
    class Private;
    Private *d;
};

#endif//SOCIALIME_H
