/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "userdictionaryobject.h"
#include "userdictionary.h"
#include "translator.h"

class UserDictionaryObject::Private : private QObject
{
    Q_OBJECT
public:
    Private(UserDictionaryObject *parent);
    ~Private();

private slots:
    void enabledChanged(bool enabled);

private:
    UserDictionaryObject *q;
    UserDictionary *editor;
};

UserDictionaryObject::Private::Private(UserDictionaryObject *parent)
    : QObject(parent)
    , q(parent)
    , editor(0)
{
    q->setGroups(QStringList() << QLatin1String("X11 Classic"));
    q->setCategoryType(AlwaysOne);
    TR(q, "categoryName", this,  QT_TR_NOOP("User Interface/User Dictionary Editor"));
    q->setIcon(QIcon(":/icons/dictionary.png"));
    TR(q, "name", this, QT_TR_NOOP("Default user dictionary editor"));
    TR(q, "author", this, QT_TR_NOOP("Tasuku Suzuki"));
    TR(q, "translator", this, QT_TR_NOOP("None"));
    connect(q, SIGNAL(enabledChanged(bool)), this, SLOT(enabledChanged(bool)), Qt::QueuedConnection);
    enabledChanged(q->isEnabled());
}

UserDictionaryObject::Private::~Private()
{
    delete editor;
}

void UserDictionaryObject::Private::enabledChanged(bool enabled)
{
    if (enabled && !editor) {
        editor = new UserDictionary;
    } else if (!enabled && editor) {
        delete editor;
        editor = 0;
    }
}

UserDictionaryObject::UserDictionaryObject(QObject *parent)
    : QimsysAbstractPluginObject(parent)
{
    d = new Private(this);
}

UserDictionaryObject::~UserDictionaryObject()
{
    delete d;
}

#include "userdictionaryobject.moc"
