/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "systemtraysettings.h"
#include "ui_systemtraysettings.h"
#include "qimsysabstractpluginobject.h"
#include "translator.h"

#include <QSettings>

class SystemTraySettings::Private : private QObject
{
    Q_OBJECT
public:
    Private(QimsysAbstractPluginObject *plugin, SystemTraySettings *parent);
    ~Private();

    void save();
private:
    SystemTraySettings *q;
    Ui::SystemTraySettings ui;
};

SystemTraySettings::Private::Private(QimsysAbstractPluginObject *plugin, SystemTraySettings *parent)
    : QObject(parent)
    , q(parent)
{
    Translator::begin();
    ui.setupUi(q);
    Translator::ui(q);
    Translator::end();
    QSettings settings;
    settings.beginGroup(q->metaObject()->className());
    ui.animation->setChecked(settings.value("Animation", true).toBool());

    ui.tabWidget->addTab(q->about(plugin, "", ui.tabWidget), "");
    TR(ui.tabWidget, 1, this, QT_TR_NOOP("&About Plugin"));
}

SystemTraySettings::Private::~Private()
{
    QSettings settings;
    settings.beginGroup(q->metaObject()->className());
    settings.setValue("Animation", ui.animation->isChecked());
}

void SystemTraySettings::Private::save()
{
}

SystemTraySettings::SystemTraySettings(QimsysAbstractPluginObject *plugin, QWidget *parent)
    : QimsysSettingsWidget(parent)
{
    d = new Private(plugin, this);
}

SystemTraySettings::~SystemTraySettings()
{
    delete d;
}

void SystemTraySettings::save()
{
    d->save();
}

#include "systemtraysettings.moc"
