/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "settingsobject.h"
#include "settingsdialog.h"
#include "qimsysapplicationmanager.h"
#include "translator.h"

#include <QPointer>

class SettingsObject::Private : private QObject
{
    Q_OBJECT
public:
    Private(SettingsObject *parent);
    ~Private();

private slots:
    void enabledChanged(bool enabled);
    void triggered(int type);

private:
    SettingsObject *q;
    QPointer<SettingsDialog> dialog;
    QimsysApplicationManager manager;
};

SettingsObject::Private::Private(SettingsObject *parent)
    : QObject(parent)
    , q(parent)
{
    q->setCategoryType(AlwaysOne);
    TR(q, "categoryName", this, QT_TR_NOOP("User Interface/Settings Dialog"));
    q->setIcon(QIcon(":/icons/configure.png"));
    TR(q, "name", this, QT_TR_NOOP("Default settings"));
    TR(q, "author", this, QT_TR_NOOP("Tasuku Suzuki"));
    TR(q, "description", this, QT_TR_NOOP("A default settings dialog"));
    TR(q, "translator", this, QT_TR_NOOP("None"));
    connect(q, SIGNAL(enabledChanged(bool)), this, SLOT(enabledChanged(bool)), Qt::QueuedConnection);
    enabledChanged(q->isEnabled());
    manager.init();
}

SettingsObject::Private::~Private()
{
    delete dialog;
}

void SettingsObject::Private::enabledChanged(bool enabled)
{
    if (enabled) {
        connect(&manager, SIGNAL(triggered(int)), this, SLOT(triggered(int)));
    } else {
        disconnect(&manager, SIGNAL(triggered(int)), this, SLOT(triggered(int)));
    }
}

void SettingsObject::Private::triggered(int type)
{
    if (type == QimsysApplicationManager::ShowSettings) {
        if (!dialog) {
            dialog = new SettingsDialog;
        }
        if (dialog->isVisible()) {
            dialog->activateWindow();
        } else {
            dialog->show();
        }
    }
}

SettingsObject::SettingsObject(QObject *parent)
    : QimsysAbstractPluginObject(parent)
{
    d = new Private(this);
}

SettingsObject::~SettingsObject()
{
    delete d;
}

#include "settingsobject.moc"
