/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "anthysettings.h"
#include "ui_anthysettings.h"
#include "translator.h"

#include <QSettings>
#include "qimsysabstractpluginobject.h"

class AnthySettings::Private : private QObject
{
    Q_OBJECT
public:
    Private(QimsysAbstractPluginObject *plugin, AnthySettings *parent);
    ~Private();

    void save();
private:
    AnthySettings *q;
    Ui::AnthySettings ui;
    QimsysAbstractPluginObject *plugin;
};

AnthySettings::Private::Private(QimsysAbstractPluginObject *p, AnthySettings *parent)
    : QObject(parent)
    , q(parent)
    , plugin(p)
{
    Translator::begin();
    ui.setupUi(q);
    Translator::ui(q);
    Translator::end();
    ui.tabWidget->addTab(q->about(plugin, ""), "");
    TR(ui.tabWidget, 1, this, QT_TR_NOOP("&About Plugin"));

    QSettings settings;
    settings.beginGroup(plugin->metaObject()->className());
    ui.empty->setChecked(settings.value("Empty", false).toBool());
    ui.prediction->setChecked(settings.value("Prediction", false).toBool());
}

AnthySettings::Private::~Private()
{
}

void AnthySettings::Private::save()
{
    QSettings settings;
    settings.beginGroup(plugin->metaObject()->className());
    settings.setValue("Empty", ui.empty->isChecked());
    settings.setValue("Prediction", ui.prediction->isChecked());
}

AnthySettings::AnthySettings(QimsysAbstractPluginObject *plugin, QWidget *parent)
    : QimsysSettingsWidget(parent)
{
    d = new Private(plugin, this);
}

AnthySettings::~AnthySettings()
{
    delete d;
}

void AnthySettings::save()
{
    d->save();
    QimsysSettingsWidget::save();
}

#include "anthysettings.moc"
