#ifndef WIDGETSETTINGS_H
#define WIDGETSETTINGS_H

#include <QDialog>
#include <QtMaemo5>
#include <QStandardItemModel>

#include "config.h"
#include "sheet.h"

namespace Ui {
    class WidgetSettings;
}

class WidgetSettings : public QDialog
{
    Q_OBJECT

public:
    explicit WidgetSettings(QWidget *parent = 0);
    ~WidgetSettings();

    int getWidth()
    { return _width; }
    TransitionsEnum getTransition()
    { return TransitionsEnum(transitionsSelector->currentIndex()); }
    QString getTheme()
    { return themesSelector->currentValueText(); }
    ActionEnum getClickAction()
    { return ActionEnum(onclickSelector->currentIndex()); }
    bool getBackground()
    { return _background; }
    bool getZeroSign()
    { return _zeroSign; }

private:
    Ui::WidgetSettings *ui;
    int _width;
    TransitionsEnum _transition;
    ActionEnum _clickAction;
    QString _theme;
    bool _background;
    bool _zeroSign;

    void updateCustomWidgets();

    QMaemo5ListPickSelector * transitionsSelector;
    QMaemo5ListPickSelector * themesSelector;
    QMaemo5ListPickSelector * onclickSelector;

    QStandardItemModel *modelTransitions;
    QStandardItemModel *modelThemes;
    QStandardItemModel *modelOnclick;

    void populatePickModel(QStandardItemModel * model,
                           QStringList items);

private slots:
    void on_pushButton_clicked();
    void on_customSizeButton_clicked();
    void on_size1Button_clicked();
    void on_size2Button_clicked();
    void on_size3Button_clicked();
    void on_size4Button_clicked();
    void on_wSpinBox_editingFinished();
    void on_backgroundCheckBox_clicked(bool checked);
    void on_zeroCheckBox_clicked(bool checked);
};

#endif // WIDGETSETTINGS_H
