#include "widgetsettings.h"
#include "ui_widgetsettings.h"

#include <QSettings>
#include <QAbstractButton>
#include <QStringList>
#include <QDir>
#include <QDebug>

#include <QTranslator>
#include <QLocale>

#include "config.h"

WidgetSettings::WidgetSettings(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::WidgetSettings)
{
    QString localeName = QLocale::system().name();

    QTranslator translator;
    translator.load("qflipclock_" + localeName,
                    TRANSLATIONS_DIR);
    QCoreApplication::installTranslator(&translator);

    ui->setupUi(this);

    QSettings settings(ORGANIZATION_NAME, APPLICATION_NAME);
    _width = settings.value("Main/Width", 400).toInt();
    _transition = TransitionsEnum(
            settings.value("Main/Transition", Transition_Flip).toInt());
    _clickAction = ActionEnum(
            settings.value("Main/ClickAction", Action_None).toInt());
    ui->wSpinBox->setValue(_width);
    if (_width == 200)
        ui->size1Button->setChecked(true);
    else if (_width == 300)
        ui->size2Button->setChecked(true);
    else if (_width == 400)
        ui->size3Button->setChecked(true);
    else if (_width == 500)
        ui->size4Button->setChecked(true);
    else
        ui->customSizeButton->setChecked(true);
    updateCustomWidgets();

    ui->transitionButton->setText(tr("Transition"));
    ui->themesButton->setText(tr("Theme"));
    ui->clickButton->setText(tr("On-Click"));

    transitionsSelector = new QMaemo5ListPickSelector;
    themesSelector = new QMaemo5ListPickSelector;
    onclickSelector = new QMaemo5ListPickSelector;

    // Transitions
    QStringList transitions;
    transitions << tr("None") << tr("Slide")
                << tr("Flip") << tr("Rotate");
    modelTransitions = new QStandardItemModel(0, 1);
    populatePickModel(modelTransitions, transitions);
    transitionsSelector->setModel(modelTransitions);
    transitionsSelector->setCurrentIndex(_transition);
    ui->transitionButton->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    ui->transitionButton->setPickSelector(transitionsSelector);

    // Themes
    _theme = settings.value("Main/Theme", "White Flip").toString();
    QDir themesDir(THEMES_DIR);
    QStringList filter("*.ini");
    QStringList fileList = themesDir.entryList(filter, QDir::Files);
    QStringList themes;
    int currentThemeIdx(0);
    for (int i = 0; i < fileList.count(); ++i)
    {
        QSettings theme(THEMES_DIR + fileList.at(i), QSettings::IniFormat);
        QString currentTheme = theme.value("Theme/Name",
                                   tr("unnamed")).toString();
        themes << currentTheme;
        if (_theme == currentTheme)
            currentThemeIdx = i;
    }
    modelThemes = new QStandardItemModel(0, 1);
    populatePickModel(modelThemes, themes);
    themesSelector->setModel(modelThemes);
    themesSelector->setCurrentIndex(currentThemeIdx);
    ui->themesButton->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    ui->themesButton->setPickSelector(themesSelector);

    // Clickactions
    QStringList actions;
    actions << tr("None") << tr("FlipClock")
                << tr("Maemo Clock");
    modelThemes = new QStandardItemModel(0, 1);
    populatePickModel(modelThemes, actions);
    onclickSelector->setModel(modelThemes);
    onclickSelector->setCurrentIndex(_clickAction);
    ui->clickButton->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    ui->clickButton->setPickSelector(onclickSelector);

    // Other settings
    _background = settings.value("Main/ShowBackground", true).toBool();
    ui->backgroundCheckBox->setChecked(_background);
    _zeroSign = settings.value("Main/PrependZeroSign", true).toBool();
    ui->zeroCheckBox->setChecked(_zeroSign);
}

WidgetSettings::~WidgetSettings()
{
    delete ui;
}

void WidgetSettings::on_pushButton_clicked()
{
    accept();
}

void WidgetSettings::on_customSizeButton_clicked()
{
    _width = ui->wSpinBox->value();
    updateCustomWidgets();
}

void WidgetSettings::updateCustomWidgets()
{
    bool isCustom(ui->customSizeButton->isChecked());

    ui->wSpinBox->setEnabled(isCustom);
}

void WidgetSettings::on_size1Button_clicked()
{
    _width = 200;
    updateCustomWidgets();
}

void WidgetSettings::on_size2Button_clicked()
{
    _width = 300;
    updateCustomWidgets();
}

void WidgetSettings::on_size3Button_clicked()
{
    _width = 400;
    updateCustomWidgets();
}

void WidgetSettings::on_size4Button_clicked()
{
    _width = 500;
    updateCustomWidgets();
}

void WidgetSettings::on_wSpinBox_editingFinished()
{
    _width = ui->wSpinBox->value();
}

void WidgetSettings::on_backgroundCheckBox_clicked(bool checked)
{
    _background = checked;
}

void WidgetSettings::populatePickModel(QStandardItemModel * model,
                                       QStringList items)
{
    for (int i = 0; i != items.count(); ++i)
    {
        QStandardItem *item = new QStandardItem(items[i]);
        item->setTextAlignment(Qt::AlignCenter);
        item->setEditable(false);
        model->appendRow(item);
    }
}

void WidgetSettings::on_zeroCheckBox_clicked(bool checked)
{
   _zeroSign = checked;
}
