#ifndef QFLIPCLOCK_WIDGET_H
#define QFLIPCLOCK_WIDGET_H

#include <QMouseEvent>
#include "qflipclock.h"
#include "sheet.h"

class QFlipClock_Widget : public QFlipClock
{
    Q_OBJECT
public:
    QFlipClock_Widget();
    QSize sizeHint() const;

public slots:
    void showSettingsDialog();
    void homescreenChangedHook(bool isCurrentHomescreen);

private:
    void setNewWidth(int width);
    void setNewTransition(TransitionsEnum transition);
    void setNewTheme(QString name);
    void setNewClickAction(ActionEnum action);
    void setNewShowBackground(bool value);
    void setNewZeroSign(bool value);
    void launchApp();

    ActionEnum _clickAction;
\
protected:
    void mouseReleaseEvent(QMouseEvent *);
};

#endif
