#ifndef THEME_H
#define THEME_H

#include <QBrush>
#include <QString>
#include <QLinearGradient>
#include <QSettings>
#include <QFont>

class Theme : public QObject
{
public:
    enum {
        Native,
        Image, // not supported yet
    };
    Theme();

    QBrush getBgBrush()
    { return _bg_brush; }
    QBrush getSheetBrush()
    { return _sheet_brush; }
    QBrush getTextBrush()
    { return _text_brush; }
    bool DrawEdge()
    { return _drawEdge; }
    QColor EdgeColor()
    { return _edgeColor; }
    bool DrawMiddleLine()
    { return _drawMiddleLine; }
    QColor MiddleLineColor()
    { return _middleLineColor; }
    QFont getFont()
    { return _font; }
    qreal getFontScale()
    { return _fontScale; }
    bool hasSemicolon()
    { return _hasSemicolon; }
    int getCornerRadius()
    { return _cornerRadius; }
    qreal getAspect()
    { return _aspect; }
    qreal getXPad()
    { return _xpad; }
    qreal getGap()
    { return _gap; }
    bool getAmPmHasEffects()
    { return _amPmHasEffects; }

    void updateTheme();
    QPixmap drawText(qreal fontScale,
                     QString str, const QRect &rect,
                     bool useEffects);

private:
    int _type;
    QBrush _bg_brush;
    QBrush _sheet_brush;
    QBrush _text_brush;
    bool _drawEdge, _drawMiddleLine;
    QColor _middleLineColor, _edgeColor;
    QFont _font;
    qreal _fontScale;
    bool _hasSemicolon;
    int _cornerRadius;
    qreal _aspect;
    qreal _xpad, _gap;
    QBrush _shadowBrush;
    QBrush _outlineBrush;
    bool _shadow, _outline;
    int _shadowXOffset, _shadowYOffset;
    qreal _outlineWidth;
    bool _amPmHasEffects;

    QColor buildColor(QSettings & theme, QString group);
    QLinearGradient buildGradient(QSettings & theme, QString group);
    QBrush setBrush(QSettings & theme, QString type);

    void updateTheme(QString name);
};

#endif // THEME_H
