#ifdef QFLIPCLOCK_WIDGET
#include "qmaemo5homescreenadaptor.h"
#include "qflipclock-widget.h"
#else
#include "qflipclock-standalone.h"
#endif

#include <QtGui>
#include <QCoreApplication>
#include <QTranslator>
#include <QLocale>

#ifdef Q_WS_MAEMO_5
#ifdef DEBUG
#include <QDebug>
#include <stdio.h>
#include <stdlib.h>
void myMessageOutput(QtMsgType type, const char *msg)
{

    FILE * fp = fopen("/home/user/MyDocs/qflipclock.debug.log", "a");
    if (!fp)
        return;
    switch (type)
    {
    case QtDebugMsg:
        fprintf(fp, "Debug: %s\n", msg);
        break;
    case QtWarningMsg:
        fprintf(fp, "Warning: %s\n", msg);
        break;
    case QtCriticalMsg:
        fprintf(fp, "Critical: %s\n", msg);
        break;
    case QtFatalMsg:
        fprintf(fp, "Fatal: %s\n", msg);
        abort();
    }
    fclose(fp);
}
#endif
#endif

int main(int argc, char *argv[])
{
#ifdef Q_WS_MAEMO_5
    QApplication::setGraphicsSystem("native");
#ifdef DEBUG
   qInstallMsgHandler(myMessageOutput);
#endif
#endif

    QApplication app(argc, argv);

    QString localeName = QLocale::system().name();

    QTranslator translator;
    translator.load("qflipclock_" + localeName,
                    TRANSLATIONS_DIR);
    QCoreApplication::installTranslator(&translator);

#ifdef QFLIPCLOCK_WIDGET
    QFlipClock_Widget w;
    QMaemo5HomescreenAdaptor *adaptor = new QMaemo5HomescreenAdaptor(&w);
    adaptor->setSettingsAvailable(true);
    QObject::connect(adaptor, SIGNAL(settingsRequested()), &w, SLOT(showSettingsDialog()));
    QObject::connect(adaptor, SIGNAL(homescreenChanged(bool)), &w, SLOT(homescreenChangedHook(bool)));
#else
    QFlipClock_App w;
#endif

    w.show();

    app.exec();
}
