#ifndef HOUR_H
#define HOUR_H

#include <QPixmap>
#include "theme.h"
#include "sheet.h"

class Hour : public Sheet
{
    Q_OBJECT
public:
    explicit Hour(QWidget *parent = 0, Theme * theme = 0, bool is24 = true);
    void setNumber(int n);
    void flipTo(int n, bool force);
    void setHoursMode(bool is24)
    { _is24 = is24; paintStatic(); }
    void setAddZero(bool value)
    { _addZero = value; paintStatic(); }

signals:

public slots:

protected:
    void preparePixmap();

private:
    bool _is24; // 24h/12h mode
    bool _isAm; // AM/PM
    int convertTime(int n);
    bool _addZero;

    QPixmap drawAmPm(const QRect rect);
};

#endif // HOUR_H
