#include "hour.h"
#include "config.h"

Hour::Hour(QWidget *parent, Theme * theme, bool is24) :
    Sheet(parent, theme),
    _is24(is24),
    _addZero(true)
{
}

void Hour::setNumber(int n)
{
    Sheet::setNumber(convertTime(n));
}

void Hour::flipTo(int n, bool force)
{
    Sheet::flipTo(convertTime(n), force);
}

int Hour::convertTime(int n)
{
    if (_is24)
        return n;

    _isAm = (n < 12);
    int h = (_isAm) ? n : n - 12;
    if (h == 0)
        h = 12;
    return h;
}

/*
 * Hour Pixmap need some additional tasks
 */
void Hour::preparePixmap()
{
    _pixmap = QPixmap(size());
    _pixmap.fill(Qt::transparent);
    QPainter p;
    p.begin(&_pixmap);
    p.drawPixmap(0, 0, drawDigits(_number, rect(), _addZero));
    if (!_is24)
        p.drawPixmap(0, 0, drawAmPm(rect()));
    p.end();
}

QPixmap Hour::drawAmPm(const QRect rect)
{
    QString str = (_isAm) ? tr("AM") : tr("PM");

    return _theme->drawText(0.4, str,
                    QRect(rect.topLeft(),
                    QSize(rect.width()/3,
                          rect.height()/3)),
                            _theme->getAmPmHasEffects());
}
