#include "widgetsettings.h"
#include "ui_widgetsettings.h"

#include <QSettings>
#include <QAbstractButton>
#include <QStringList>
#include <QDir>
#include <QDebug>

#include <QTranslator>
#include <QLocale>

#include "config.h"

WidgetSettings::WidgetSettings(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::WidgetSettings)
{
    QString localeName = QLocale::system().name();

    QTranslator translator;
    translator.load("qflipclock_" + localeName,
                    TRANSLATIONS_DIR);
    QCoreApplication::installTranslator(&translator);

    ui->setupUi(this);

    QSettings settings(ORGANIZATION_NAME, APPLICATION_NAME);
    int m_width = settings.value("Main/Width", 400).toInt();
    int m_height = settings.value("Main/Height", 266).toInt();
    _transition = TransitionsEnum(
            settings.value("Main/Transition", Transition_Flip).toInt());
    _clickAction = ActionEnum(
            settings.value("Main/ClickAction", Action_None).toInt());
    _size = QSize(m_width, m_height);
    ui->wSpinBox->setValue(m_width);
    ui->hSpinBox->setValue(m_height);
    if (m_width == 240 && m_height == 160)
        ui->size1Button->setChecked(true);
    else if (m_width == 400 && m_height == 266)
        ui->size2Button->setChecked(true);
    else if (m_width == 500 && m_height == 416)
        ui->size3Button->setChecked(true);
    else
        ui->customSizeButton->setChecked(true);
    updateCustomWidgets();

    // Transitions
    QStringList transitions;
    transitions << tr("None") << tr("Slide")
                << tr("Flip") << tr("Rotate");
    ui->transitionCombo->blockSignals(true);
    ui->transitionCombo->insertItems(0, transitions);
    ui->transitionCombo->setCurrentIndex(_transition);
    ui->transitionCombo->blockSignals(false);
    
    // Themes
    _theme = settings.value("Main/Theme", "White Flip").toString();
    QDir themesDir(THEMES_DIR);
    QStringList filter("*.ini");
    QStringList fileList = themesDir.entryList(filter, QDir::Files);
    QString str;
    ui->themesCombo->blockSignals(true);
    foreach (str, fileList)
    {
        QSettings theme(THEMES_DIR + str, QSettings::IniFormat);
        QString name = theme.value("Theme/Name",
                                   tr("unnamed")).toString();
        ui->themesCombo->insertItem(0, name);
    }
    ui->themesCombo->setCurrentIndex(ui->themesCombo->findText(_theme));
    ui->themesCombo->blockSignals(false);

    // Clickactions
    QStringList actions;
    actions << tr("None") << tr("FlipClock")
                << tr("Maemo Clock");
    ui->clickCombo->blockSignals(true);
    ui->clickCombo->insertItems(0, actions);
    ui->clickCombo->setCurrentIndex(_clickAction);
    ui->clickCombo->blockSignals(false);

}

WidgetSettings::~WidgetSettings()
{
    delete ui;
}

void WidgetSettings::on_pushButton_clicked()
{
    accept();
}

void WidgetSettings::on_customSizeButton_clicked()
{
    _size = QSize(ui->wSpinBox->value(),
                  ui->hSpinBox->value());
    updateCustomWidgets();
}

void WidgetSettings::updateCustomWidgets()
{
    bool isCustom(ui->customSizeButton->isChecked());

    ui->wSpinBox->setEnabled(isCustom);
    ui->hSpinBox->setEnabled(isCustom);
    ui->xLabel->setEnabled(isCustom);
}

void WidgetSettings::on_size1Button_clicked()
{
    _size = QSize(240, 160);
    updateCustomWidgets();
}

void WidgetSettings::on_size2Button_clicked()
{
    _size = QSize(400, 266);
    updateCustomWidgets();
}

void WidgetSettings::on_size3Button_clicked()
{
    _size = QSize(500, 416);
    updateCustomWidgets();
}

void WidgetSettings::on_wSpinBox_editingFinished()
{
    _size = QSize(ui->wSpinBox->value(),
                  ui->hSpinBox->value());
}

void WidgetSettings::on_hSpinBox_editingFinished()
{
    _size = QSize(ui->wSpinBox->value(),
                  ui->hSpinBox->value());
}

void WidgetSettings::on_transitionCombo_activated(int index)
{
    _transition = TransitionsEnum(index);
}

void WidgetSettings::on_themesCombo_activated(QString text)
{
    _theme = text;
}

void WidgetSettings::on_clickCombo_activated(int index)
{
    _clickAction = ActionEnum(index);
}
