#ifndef SETTINGS_H
#define SETTINGS_H

#include <QDialog>
#include "config.h"
#include "sheet.h"

namespace Ui {
    class Settings;
}

class Settings : public QDialog
{
    Q_OBJECT

public:
    explicit Settings(QWidget* parent = 0);
    ~Settings();

    TransitionsEnum getTransition()
    { return _transition; }
    QString getTheme()
    { return _theme; }
    bool getKeepBacklight()
    { return _keepBacklight; }

private:
    Ui::Settings *ui;
    TransitionsEnum _transition;
    QString _theme;
    bool _keepBacklight;

private slots:
    void on_backlightCheck_toggled(bool checked);
    void on_themesCombo_activated(QString );
    void on_transitionCombo_activated(int index);
    void on_pushButton_clicked();
};

#endif // SETTINGS_H
