#include <QTime>
#include <QAction>
#include <QMenuBar>
#include <QDebug>

#if defined(Q_WS_MAEMO_5) && defined(QFLIPCLOCK_WIDGET)
#include <QtDBus/QtDBus>
#endif

#include "qflipclock.h"

#ifdef QFLIPCLOCK_WIDGET
QFlipClock::QFlipClock(QWidget *parent)
    : QWidget(parent)
    , _transition(Transition_Flip)
    , _clickAction(Action_None)
#else
QFlipClock::QFlipClock(QMainWindow *parent)
        : QMainWindow(parent)
        , _transition(Transition_Flip)
#endif
{
    _theme = new Theme();

    reloadTheme();

    _hour = new Sheet(this, _theme);
    _hour->show();
    _minute = new Sheet(this, _theme);
    _minute->show();

    QTime t = QTime::currentTime();
    _hour->setNumber(t.hour());
    _minute->setNumber(t.minute());

    updateTime();
    startTimer();
}

QFlipClock::~QFlipClock()
{

}

void QFlipClock::updateTime(bool force)
{
    QTime t = QTime::currentTime();
    _hour->flipTo(t.hour(), force);
    _minute->flipTo(t.minute(), force);
}


void QFlipClock::setTransition(TransitionsEnum i)
{
    _hour->setTransition(i);
    _minute->setTransition(i);
    updateTime();
}

void QFlipClock::resizeEvent(QResizeEvent*)
{
    int digitsWidth = width() / 2 - _gap/2 - _xpad;
    int digitsHeight = digitsWidth * _aspect;

    int y = (height() - digitsHeight) / 2;

    _hour->resize(digitsWidth, digitsHeight);
    _hour->move(_xpad, y);

    _minute->resize(digitsWidth, digitsHeight);
    _minute->move(width() / 2 + _gap / 2, y);
}

void QFlipClock::timerEvent(QTimerEvent * event)
{
    if (event->timerId() == _ticker.timerId())
    {
        updateTime();
    }
}

void QFlipClock::updateTheme()
{
    _theme->updateTheme();
    reloadTheme();
    _hour->reloadTheme();
    _minute->reloadTheme();
    emit(resizeEvent(0));
    updateTime();
}

void QFlipClock::reloadTheme()
{
    _aspect = _theme->getAspect();
    _xpad = width() / 2 * _theme->getXPad();
    _gap = width() / 2 * _theme->getGap();
}

/*
 * Reimplement this to draw Background
 */
void QFlipClock::paintEvent(QPaintEvent *)
{
    QPainter p(this);
    p.setBrush(_theme->getBgBrush());
    p.setPen(Qt::NoPen);
    p.drawRoundedRect(rect(), 25, 25);
    p.end();
}

void QFlipClock::stopTimer()
{
    if (_ticker.isActive())
        _ticker.stop();
}

void QFlipClock::startTimer()
{
    if (!_ticker.isActive())
        _ticker.start(1000, this);
}

#ifdef QFLIPCLOCK_WIDGET
void QFlipClock::setClickAction(ActionEnum i)
{
    _clickAction = i;
}
#endif

#ifdef Q_WS_MAEMO_5
void QFlipClock::mousePressEvent(QMouseEvent *)
{
#ifdef QFLIPCLOCK_WIDGET
    if (_clickAction == Action_Flipclock)
    {
        QDBusConnection bus = QDBusConnection::sessionBus();
        QDBusInterface dbus_iface("com.nokia.HildonDesktop.AppMgr",
                                  "/com/nokia/HildonDesktop/AppMgr",
                                  "com.nokia.HildonDesktop.AppMgr",
                                  bus);
        dbus_iface.call("LaunchApplication","qflipclock");
    }
    else if (_clickAction == Action_Maemoclock)
    {
        QDBusConnection bus = QDBusConnection::sessionBus();
        QDBusInterface dbus_iface("com.nokia.HildonDesktop.AppMgr",
                                  "/com/nokia/HildonDesktop/AppMgr",
                                  "com.nokia.HildonDesktop.AppMgr",
                                  bus);
        dbus_iface.call("LaunchApplication","worldclock");
    }
#else
    toggleSize();
#endif /* QFLIPCLOCK_WIDGET */
}
#endif

#ifdef QFLIPCLOCK_STANDALONE
void QFlipClock::toggleSize()
{
        bool isFullScreen = windowState() & Qt::WindowFullScreen;
        if (isFullScreen)
        {
            resize(DEFAULT_WIDTH, DEFAULT_HEIGHT);
            showNormal();
        }
        else
        {
            resize(MAX_WIDTH, MAX_HEIGHT);
            showFullScreen();
        }
}
#endif
