#include <QDebug>
#include <QApplication>
#include <QDir>
#include <QFile>
#include <QTextStream>
#include <QWebView>
#include <QWebFrame>
#include <QFileDialog>
#include <QMessageBox>
#include <QKeyEvent>

#include "mainwindow.h"
#include "ui_mainwindow.h"

#ifdef Q_WS_MAEMO_5
#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusConnectionInterface>
#include <QtDBus/QDBusInterface>
#include <QtDBus/QDBusReply>
#endif

QString VERSION="0.1.1",TITLE;

MainWindow::MainWindow(QWidget *parent) :
  QMainWindow(parent),
  ui(new Ui::MainWindow)
{
 ui->setupUi(this);
 web=ui->web;
 setCentralWidget(web);
 TITLE="%1 - "+windowTitle();
 QString tempDir=defDir=qApp->applicationDirPath();

#ifdef Q_WS_MAEMO_5
 setAttribute(Qt::WA_Maemo5AutoOrientation);
 setAttribute(Qt::WA_Maemo5NonComposited);
 web->setAttribute(Qt::WA_Maemo5NonComposited);
 ui->menuFile->removeAction(ui->aPrev);
 ui->menuFile->removeAction(ui->aNext);
 ui->menuSettings->removeAction(ui->aFullscreen);
 ui->menuFile->addAction(ui->aFullscreen);
 ui->menuSettings->addAction(ui->aPrev);
 ui->menuSettings->addAction(ui->aNext);
 // without temp and html dont work :(
 tempDir=defDir="/home/user/MyDocs";

 if(qApp->argc()>1)
 {
  swfFile=qApp->arguments().at(1);
 }
#endif

 html="<html><head></head><body Style=\"margin:0;-webkit-user-select:none;overflow:hidden;\">"
      "<object type=\"application/x-shockwave-flash\" data=\"%1\" width=\"100%\" height=\"100%\">"
      "</object></body></html>";
 tmpFile=tempDir+"/qflashtemp.htm";
 swfFile.replace('\\','/');
 //qDebug() << "file:" << swfFile;
 tempUrl="file://localhost/"+tmpFile;
 createTempFile();
 web->setAttribute(Qt::WA_OpaquePaintEvent);
 web->setAttribute(Qt::WA_NoSystemBackground);
 web->page()->settings()->setAttribute(QWebSettings::JavascriptEnabled,false);
 web->page()->settings()->setAttribute(QWebSettings::PluginsEnabled,true);
 web->load(QUrl(tempUrl));
 if(QFile::exists(swfFile)) openFileFromCurDir(0);
}

void MainWindow::createTempFile()
{
 QFile file(tmpFile);
 if(file.open(QIODevice::WriteOnly | QIODevice::Truncate))
 {
  QTextStream stream(&file);
  stream << html.arg(swfFile) << endl;
  file.close();
 } else return;

}

MainWindow::~MainWindow()
{
 delete ui;
 QFile::remove(tmpFile);
}

void MainWindow::changeEvent(QEvent *e)
{
 QMainWindow::changeEvent(e);
 switch (e->type()) {
 case QEvent::LanguageChange:
  ui->retranslateUi(this);
  break;
 case QEvent::KeyPress:
  {
   QKeyEvent* event = (QKeyEvent*)e;
   Qt::Key key = (Qt::Key)event->key();

   if(key==Qt::Key_Escape) close();
  }
  break;
 default:
  break;
 }
}

void MainWindow::on_aFullscreen_triggered()
{
 if(windowState()==Qt::WindowFullScreen)
      showNormal();
 else showFullScreen();
}

void MainWindow::on_aAbout_triggered()
{
 QMessageBox::about(this,tr("About")+" qFlash",QString(
                    "<p><font size=5><b>qFlash</b></font> - %1.</p>"
                    "<p>%2 %3 &copy; 2011-2012 <a href=\"mailto:guuleon@gmail.com\">Leonid Gusak</a><hr><p>%4</p>")
                    .arg(tr("simple flash player")).arg(tr("Version")).arg(VERSION)
                    .arg(tr("This program is distributed in the hope that it will be useful, "
                            "but WITHOUT ANY WARRANTY; without even the implied warranty of "
                            "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the "
                            "GNU General Public License for more details.")) );
}

void MainWindow::on_aNext_triggered()
{
 openFileFromCurDir(1);
}

void MainWindow::on_aPrev_triggered()
{
 openFileFromCurDir(-1);
}

void MainWindow::openFileFromCurDir(int offset)
{
 QDir Dir;
 QString swfFileName;
 swfFile = Dir.absoluteFilePath(swfFile);
 curDir=swfFile.section('/',0,-2);
 swfFileName=swfFile.section('/',-1);
 Dir.setCurrent(curDir);
 if(!swfList.count())
  foreach(QFileInfo info, Dir.entryInfoList(QDir::NoDotAndDotDot | QDir::Files))
  {
   QRegExp regExp=QRegExp("*.swf",Qt::CaseInsensitive,QRegExp::Wildcard);
   if(info.isFile() && info.fileName().contains(regExp))
   {
    QString FileName=info.fileName();
    int lastIndex;
    swfList << FileName;
    lastIndex=swfList.count()-1;
    if(FileName==swfFileName) swfIndex=lastIndex;
    ui->aPrev->setEnabled(swfIndex);
    ui->aNext->setEnabled(swfIndex!=lastIndex);
   }
  }

 int newIndex=swfIndex+offset,lastIndex=swfList.count()-1;
 if(newIndex<0 || newIndex>lastIndex) return;
 swfIndex=newIndex;
 setWindowTitle(TITLE.arg(swfList.at(swfIndex)));
 if(!isVisible()) return; // from command line

 ui->aPrev->setEnabled(swfIndex);
 ui->aNext->setEnabled(swfIndex!=lastIndex);
 swfFile=curDir+"/"+swfList.at(swfIndex);
 createTempFile();
 web->reload();
 QFile::remove(tmpFile); // but ...
}

void MainWindow::on_aOpen_triggered()
{
 QString fileName = QFileDialog::getOpenFileName(this,
                                                 tr("Open file"),
                                                 (curDir.isEmpty() ? defDir:curDir),
                                                 "SWF - Flash (*.swf)");
 if (fileName.isEmpty()) return;
 swfFile=fileName;
 swfList.clear();
 createTempFile();
 openFileFromCurDir(0);
}
