#include "dayhistory.h"

DayHistory::DayHistory(QWidget *parent) :
        QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);

    xml = new XML();

    lstExercises = new QListView();
    model = new QStandardItemModel(this);
    lstExercises->setModel(model);
    connect(lstExercises,SIGNAL(clicked(QModelIndex)),this,SLOT(showInfo(QModelIndex)));

    setCentralWidget (lstExercises);
}

void DayHistory::showInfo(QModelIndex index)
{
    QString name, group;
    int mid;

    mid = index.data().toString().indexOf("/");
    group = index.data().toString().left(mid);
    mid = index.data().toString().count() - mid - 1;
    name = index.data().toString().right(mid);


    hiw = new HistoryInfoWindow(this);
    hiw->load(name,group);
    hiw->show();
}

void DayHistory::load(QString date)
{
    QList <QString> tmp;
    QString name, group;
    setWindowTitle(date);
    model->clear();
    exercises = xml->getHistoryByDate(date);

    while(!exercises.isEmpty())
    {
        tmp = exercises.takeFirst();
        name = tmp.takeFirst();
        group = tmp.takeFirst();

        model->appendRow(new QStandardItem(group + "/" + name ));
    }

}
