#ifndef INFOWINDOW_H
#define INFOWINDOW_H

#include <QMainWindow>
#include <QtGui>
#include "newexercisewindow.h"
#include "newprogramwindow.h"
#include "settingswindow.h"
#include "exercisewindow.h"
#include "xml.h"
#include "newingredientwindow.h"
#include "historywindow.h"


//class ExerciseWindow;

class InfoWindow : public QMainWindow
{
    Q_OBJECT
public:
    explicit InfoWindow(QWidget *parent = 0);
    void loadExercise(QString name);

signals:
    void closed();
    void landscape();

public slots:
    void sendClosed();
    void sendLandscape();

private:
    SettingsWindow *sw;
    HistoryWindow *hw;
    NewExerciseWindow *nw;
    NewProgramWindow *npw;
    ExerciseWindow *ew;
    NewIngredientWindow *niw;
    XML *xml;

    void createActions();
    void createMenu();
    void changeEvent(QEvent *event);

    QAction *settingsAction;
    QAction *newExerciseAction;
    QAction *newProgramAction;
    QAction *newIngredientAction;
    QAction *historyAction;

    QLabel *lblName;
    QLabel *lblMuscle;
    QLabel *lblSet;
    QLabel *lblReps;
    QLabel *lblRest;
    QLabel *lblInfo;
    QLabel *lblLast;

    QPushButton *btnBack;
    QPushButton *btnForward;
    QPushButton *btnStart;

    QString info;
    QString exerciseName;
    QTextEdit *txtInfo;

    QGridLayout *gLayout;
    QGridLayout *gButtonLayout;

    QString weight[10], reps[10], status[10];

private slots:
    void showSettings();
    void showNewExercise();
    void showNewProgram();
    void startExercise();
    void forward();
    void back();
    void orientationChanged();
    void showNewIngredient();
    void showHistory();

};

#endif // INFOWINDOW_H
