#ifndef DAYHISTORY_H
#define DAYHISTORY_H

#include <QMainWindow>
#include <QtGui>
#include "xml.h"
#include "historyinfowindow.h"

class DayHistory : public QMainWindow
{
    Q_OBJECT

public:
    explicit DayHistory(QWidget *parent = 0);
    void load(QString date);

private:
    XML *xml;
    HistoryInfoWindow *hiw;

    void changeEvent(QEvent *event);

    QListView *lstExercises;
    QList < QList <QString> > exercises;
    QStandardItemModel *model;

    QString currentDate;

private slots:
    void showInfo(QModelIndex index);
    void showContextMenuForWidget(const QPoint &pos);
    void deleteItem();

};

#endif //DAYHISTORY_H
