#ifndef MOTIONWINDOW_H
#define MOTIONWINDOW_H

#include <QMainWindow>
#include <QtGui>
#include "weightdialog.h"
#include "newexercisewindow.h"
#include "newprogramwindow.h"
#include "settingswindow.h"
#include "newingredientwindow.h"
#include "historywindow.h"


class MotionWindow : public QMainWindow
{
    Q_OBJECT
public:
    explicit MotionWindow(QWidget *parent = 0);
    void load(QString name);

signals:
    void closed();
    void landscape();

public slots:
    void sendClosed();

private:
    WeightDialog *wd;
    HistoryWindow *hw;
    SettingsWindow *sw;
    NewExerciseWindow *nw;
    NewProgramWindow *npw;
    NewIngredientWindow *niw;

    void createActions();
    void createMenu();
    void closeEvent(QCloseEvent *event);


    QAction *settingsAction;
    QAction *newExerciseAction;
    QAction *newProgramAction;
    QAction *newIngredientAction;
    QAction *historyAction;


    QLabel *label;
    QPushButton *button;
    QTimer *tmr;

    int sec, min;
    QString name;

private slots:
    void update();
    void buttonClicked();
    void showSettings();
    void showNewExercise();
    void showNewProgram();
    void showNewIngredient();
    void showHistory();

};

#endif // MOTIONWINDOW_H
