#include "newprogramwindow.h"

#include <QMaemo5InformationBox>
#include <QDebug>

NewProgramWindow::NewProgramWindow(QWidget *parent) :
    QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setWindowTitle("New program");

    xml = new XML();

    QWidget *widget = new QWidget();

    vLayout = new QVBoxLayout();

    txtName = new QLineEdit();
    txtName->setPlaceholderText("Name");
    vLayout->addWidget(txtName);

    model = new QStandardItemModel();
    lstExercises = new QListView();
    lstExercises->setModel(model);
    lstExercises->setSelectionMode(QListView::MultiSelection);
    vLayout->addWidget(lstExercises);

    btnSave = new QPushButton("Save");
    connect(btnSave, SIGNAL(clicked()), this, SLOT(saveExercise()));
    vLayout->addWidget(btnSave);

    widget->setLayout(vLayout);
    setCentralWidget(widget);
}

void NewProgramWindow::load()
{
    QList <QString> list;
    list = xml->openAll();

    if(list.isEmpty())
    {
        model->appendRow(new QStandardItem ("No exercises"));
        lstExercises->setSelectionMode(QListView::NoSelection);
        return;
    }

    while(!list.isEmpty())
    {
        model->appendRow(new QStandardItem(list.takeFirst()));
    }
    model->sort(0);

}

void NewProgramWindow::load(QString name, QList <QString> exercises)
{
    QList <QString> list;
    QModelIndex index;
    qDebug() << "NewProgramWindow::load name:" << name;
    oldName = name;
    list = xml->openAll();
    qDebug() << "NewProgramWindow::load 1";
    if(list.isEmpty())
    {
        model->appendRow(new QStandardItem ("No exercises"));
        lstExercises->setSelectionMode(QListView::NoSelection);
        return;
    }

    qDebug() << "NewProgramWindow::load 2";
    while(!list.isEmpty())
    {
        model->appendRow(new QStandardItem(list.takeFirst()));
    }

    model->sort(0);
    qDebug() << "NewProgramWindow::load 3";
    txtName->setText(name);
    txtName->setEnabled(false);
    qDebug() << "NewProgramWindow::load 4";

    for(int i = 0; i < exercises.count(); i++)
    {
        for(int j = 0; j < exercises.count(); j++)
        {
            if(lstExercises->model()->index(j,0).data().toString() == exercises.at(i))
            {
                index = model->index(j,0);
                lstExercises->selectionModel()->select(index, QItemSelectionModel::Select);
            }
        }
    }
}

void NewProgramWindow::saveExercise()
{
    QModelIndexList list;
    QItemSelectionModel *m = lstExercises->selectionModel();
    list = m->selectedRows();

    xml->saveProgram(txtName->text(), list);

    this->destroy();

}

