#include "programinfowindow.h"

ProgramInfoWindow::ProgramInfoWindow(QWidget *parent) :
    QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);

    xml = new XML();

    QWidget *widget = new QWidget();


    QVBoxLayout *vLayout = new QVBoxLayout;

    lblName = new QLabel();
    vLayout->addWidget(lblName);

    model = new QStandardItemModel(this);

    lstExercises = new QListView();
    lstExercises->setModel(model);
    lstExercises->setSelectionMode(QListView::NoSelection);
    lstExercises->setContextMenuPolicy(Qt::CustomContextMenu);
    connect(lstExercises, SIGNAL(customContextMenuRequested(const QPoint &)),SLOT(showContextMenuForWidget(const QPoint &)));
    vLayout->addWidget(lstExercises);

    btnStart = new QPushButton("Start Program");
    connect(btnStart,SIGNAL(clicked()),this,SLOT(start()));
    vLayout->addWidget(btnStart);

    widget->setLayout(vLayout);
    setCentralWidget(widget);

}

void ProgramInfoWindow::showContextMenuForWidget(const QPoint &pos)
{

}

void ProgramInfoWindow::start()
{
    QList <QString> list,list2;
    list = xml->loadProgram(prgm);

    ew = new ExerciseWindow(this);
    //connect(ew,SIGNAL(closed()),this,SLOT(sendClosed()));
    //connect(ew,SIGNAL(landscape()),this, SLOT(sendLandscape()));

    while(!list.isEmpty())
    {
        if(list.first() == "")
        {
            list.removeFirst();
            continue;
        }
        list2.append(list.takeFirst());
    }
    ew->loadExercise(list2);
    ew->show();
}

void ProgramInfoWindow::load(QString program)
{
    QList <QString> list;
    prgm = program;
    list = xml->loadProgram(program);
    lblName->setText(program);


    while(!list.isEmpty())
    {
        if(list.first() == "")
        {
            list.removeFirst();
            continue;
        }
        model->appendRow(new QStandardItem(list.takeFirst()));
    }
    model->sort(0);
}
