#include "historyinfowindow.h"

HistoryInfoWindow::HistoryInfoWindow(QWidget *parent) :
    QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);

    QWidget *widget = new QWidget();
    QVBoxLayout *vLayout = new QVBoxLayout();

    for(int i = 0; i < 9; i++)
    {
        lblSet[i] = new QLabel();
        vLayout->addWidget(lblSet[i]);
    }


    xml = new XML();

    widget->setLayout(vLayout);
    setCentralWidget(widget);
}

void HistoryInfoWindow::load(QString name)
{
    QList <QString> list;
    int j = 0;
    QString set;

    setWindowTitle(name);

    list = xml->getHistoryByExercise(name);

    for(int i = 0; i < 9; i++)
        lblSet[i]->setText("");

    while(!list.isEmpty())
    {
        set.setNum(j+1);
        lblSet[j]->setText("Set " + set + ": " + list.takeFirst() + " kg " +
                           list.takeFirst() + " reps - " + list.takeFirst());

        j++;
    }
}
