#include "dayhistory.h"

DayHistory::DayHistory(QWidget *parent) :
        QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);

    xml = new XML();

    lstExercises = new QListView();
    model = new QStandardItemModel(this);
    lstExercises->setModel(model);
    connect(lstExercises,SIGNAL(clicked(QModelIndex)),this,SLOT(showInfo(QModelIndex)));

    setCentralWidget (lstExercises);
}

void DayHistory::showInfo(QModelIndex index)
{
    hiw = new HistoryInfoWindow(this);
    hiw->load(index.data().toString());
    hiw->show();
}

void DayHistory::load(QString date)
{
    QList <QString> tmp;
    QString name, group;
    setWindowTitle(date);
    model->clear();
    exercises = xml->getHistoryByDate(date);

    while(!exercises.isEmpty())
    {
        tmp = exercises.takeFirst();
        name = tmp.takeFirst();
        group = tmp.takeFirst();

        if(group != "Cardio")
            model->appendRow(new QStandardItem(group + "/" + name ));
        else
            model->appendRow(new QStandardItem(group + "/" + name ));
    }

}
