#ifndef SETTINGSWINDOW_H
#define SETTINGSWINDOW_H

#include <QMainWindow>
#include <QtGui>
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>
#include "xml.h"
#include "dietsettings.h"
#include "othersettings.h"
#include "weightsettings.h"

class SettingsWindow : public QMainWindow
{
    Q_OBJECT
public:
    explicit SettingsWindow(QWidget *parent = 0);
    void load();
signals:

private slots:
    void showDiet();
    void showOther();
    void showWeight();

private:
    XML *xml;
    DietSettings *ds;
    OtherSettings *os;
    WeightSettings *ws;

    void save();

    QPushButton *btnDiet;
    QPushButton *btnOther;
    QPushButton *btnWeight;
};

#endif // SETTINGSWINDOW_H
