#include "motionwindow.h"

MotionWindow::MotionWindow(QWidget *parent) :
    QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);

    QWidget *widget = new QWidget();
    setCentralWidget(widget);

    QVBoxLayout *vLayout = new QVBoxLayout();

    label = new QLabel("Name: not started");
    label->setAlignment(Qt::AlignCenter);

    button = new QPushButton("Start");
    vLayout->addWidget(label);
    vLayout->addWidget(button);
    widget->setLayout(vLayout);

    connect(button,SIGNAL(clicked()),this,SLOT(buttonClicked()));

    tmr = new QTimer();
    QObject::connect(tmr, SIGNAL(timeout()), this, SLOT(update()));

    createActions();
    createMenu();
}

void MotionWindow::sendClosed()
{
    emit closed();
}

void MotionWindow::load(QString exercise)
{
    name = exercise;
    sec = 0;
    min = 0;
    button->setText("Start");
    label->setText(name + ": not started");
}

void MotionWindow::buttonClicked()
{
    QString strSec, strMin;

    if(button->text() == "Start")
    {
        button->setText("Stop");
        tmr->start(1000);
    }
    else
    {
        //button->setText("Start");
        tmr->stop();

        strSec.setNum(sec);
        strMin.setNum(min);

        wd = new WeightDialog(this);
        wd->loadCardio(name, strMin, strSec);
        wd->show();
    }
}


void MotionWindow::update()
{
    QString strSec, strMin;
    sec++;

    if(sec == 60)
    {
        sec = 0;
        min++;
    }

    strSec.setNum(sec);
    strMin.setNum(min);
    label->setText(name + ": " + strMin + ":" + strSec);
}

void MotionWindow::closeEvent(QCloseEvent *event)
{
    //myThread->quit();
    tmr->stop();
}

void MotionWindow::showNewIngredient()
{
    niw = new NewIngredientWindow(this);
    niw->load();
    niw->show();
}

void MotionWindow::showHistory()
{
    hw = new HistoryWindow(this);
    hw->load();
    hw->show();
}

void MotionWindow::showSettings()
{
    sw = new SettingsWindow(this);
    sw->show();
}

void MotionWindow::showNewExercise()
{
    nw = new NewExerciseWindow(this);
    emit landscape();
    connect(nw,SIGNAL(closed()),this,SLOT(sendClosed()));
    nw->load();
    nw->show();
}

void MotionWindow::showNewProgram()
{
    npw = new NewProgramWindow(this);
    npw->show();
}

void MotionWindow::createMenu()
{
    QMenu *menu;
    menu = menuBar()->addMenu(tr("&Menu"));
    menu->addAction(historyAction);
    menu->addAction(settingsAction);
    menu->addAction(newExerciseAction);
    menu->addAction(newProgramAction);
    menu->addAction(newIngredientAction);
}

void MotionWindow::createActions()
{
    historyAction = new QAction("History",this);
    settingsAction = new QAction("Settings",this);
    newExerciseAction = new QAction("New Exercise",this);
    newProgramAction = new QAction("New program",this);
    newIngredientAction = new QAction("New Ingredient",this);

    connect(historyAction, SIGNAL(triggered()), this, SLOT(showHistory()));
    connect(settingsAction, SIGNAL(triggered()), this, SLOT(showSettings()));
    connect(newExerciseAction, SIGNAL(triggered()), this, SLOT(showNewExercise()));
    connect(newProgramAction, SIGNAL(triggered()), this, SLOT(showNewProgram()));
    connect(newIngredientAction, SIGNAL(triggered()), this, SLOT(showNewIngredient()));
}
