#include "exportwindow.h"
#include <QtDebug>

ExportWindow::ExportWindow(QWidget *parent) :
    QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    xml = new XML();

    QWidget *central = new QWidget();

    QVBoxLayout *lay = new QVBoxLayout(central);
    editBar = new QMaemo5EditBar("Export exercises",this);
    lay->addWidget(editBar);

    QPushButton *pb = new QPushButton(tr("Export"));
    editBar->addButton(pb);
    connect(pb,SIGNAL(clicked()),this,SLOT(exportSelected()));

    model = new QStandardItemModel(this);

    lstExercises = new QListView();
    lstExercises->setModel(model);



    lay->addWidget(lstExercises);
    setCentralWidget(central);
    //toggleFullScreen(true);


}

void ExportWindow::loadExercises(QString grp)
{
    showFullScreen();
    QList <QString> list;
    group = grp;
    if(grp == "Cardio")
        list = xml->openCardio();
    else
        list = xml->openGroup(grp);

    model->clear();
    lstExercises->setSelectionMode(QListView::MultiSelection);
    if(list.isEmpty())
    {
        model->appendRow(new QStandardItem ("No exercises"));
        lstExercises->setSelectionMode(QListView::NoSelection);
        return;
    }

    while(!list.isEmpty())
    {
        model->appendRow(new QStandardItem(list.takeFirst()));
    }

    model->sort(0);
    lstExercises->clearSelection();
}

void ExportWindow::exportSelected()
{
    QModelIndexList list;
    QItemSelectionModel *m = lstExercises->selectionModel();
    QModelIndex tmp;
    list = m->selectedRows();
    xml->exportExercises(list);

    this->destroy();
}
