#include "xml.h"
#include <QDateTime>
#include <QtXml>
#include <QMessageBox>
#include <QtDebug> // qDebug() << "3";
XML::XML()
{

}


void XML::removeElement(QString name)
{

    QDomDocument doc( "Exercises" );
    QFile file( "/home/user/MyDocs/exercises.xml" );

    if( !file.open( QIODevice::ReadOnly ) )
      return;


    if( !doc.setContent( &file ) )
    {
      file.close();
      return;
    }
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercises" )
      return;

    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
            if(name == e.attribute( "name", "" ))
            {
                root.removeChild(n);
            }
        }
      }
      n = n.nextSibling();
  }
    if( !file.open( QIODevice::WriteOnly ) )
      return;
    QTextStream ts( &file );
    ts << doc.toString();

    file.close();
}

void XML::saveProgram(QString name, QList <QString> exercises)
{
    QDomDocument doc( "Program" );
    QFile file( "/home/user/MyDocs/program.xml" );
    file.open( QIODevice::ReadOnly );
    doc.setContent( &file );


    QDomElement root = doc.documentElement();
    if( root.tagName() != "programs" )
    {
        root = doc.createElement( "programs" );
        doc.appendChild( root );
    }
    file.remove();
    file.close();
    root.appendChild(createProgramNode(doc, name, exercises));

    if(!file.open(QIODevice::WriteOnly))
        return ;

    QTextStream ts( &file );
    ts << doc.toString();

    file.close();

    return ;
}

QDomElement XML::createProgramNode(QDomDocument &d, QString name, QList <QString> exercises)
{
    QDomElement cn = d.createElement( "program" );
    QString tal;
    cn.setAttribute( "name", name );
    for(int i= 1; i < 20; i++)
    {
        tal.setNum(i);
        if(exercises.isEmpty())
            cn.setAttribute( "exercise" + tal, "" );
        else
            cn.setAttribute( "exercise" + tal, exercises.takeFirst() );
    }

    return cn;
}

QList <QString> XML::loadProgram(QString name)
{
    QList <QString> readInfo;

    QDomDocument doc( "Program" );
    QFile file( "/home/user/MyDocs/program.xml" );
    if( !file.open( QIODevice::ReadOnly ) )
    {
        return readInfo;
    }

    doc.setContent(&file);
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "programs" )
    {
      return readInfo;
    }

    QString tal;

    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "program" )
        {

            if(name == e.attribute( "name", "" ))
            {
                for(int i = 1; i < 20; i++)
                {
                    tal.setNum(i);
                    readInfo.append(e.attribute("exercise"+tal, ""));
                }
            }
        }
      }
      n = n.nextSibling();
   }
    return readInfo;
}

void XML::saveSettings(QString vibrate, QString sound, QString volume,
                       QString set, QString reps1, QString reps2, QString reps3,
                       QString currentReps, QString min, QString sec, QString calories)
{
    QDomDocument doc( "Settings" );
    QDomElement root = doc.createElement( "setting" );
    doc.appendChild( root );

    root.appendChild(createSettingsNode(doc, vibrate, sound, volume, set, reps1, reps2, reps3, currentReps, min, sec, calories));

    QFile file( "/home/user/MyDocs/settings.xml" );
    if(!file.open(QIODevice::WriteOnly))
        return;

    QTextStream ts( &file );
    ts << doc.toString();

    file.close();
    return;
}

QList <QString> XML::loadSettings()
{
    QList <QString> readInfo;

    QDomDocument doc( "Settings" );
    QFile file( "/home/user/MyDocs/settings.xml" );
    if( !file.open( QIODevice::ReadOnly ) )
    {
        return readInfo;
    }
    doc.setContent(&file);
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "setting" )
    {
        return readInfo;
    }
    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "settings" )
        {

            readInfo.append(e.attribute("vibrate", ""));
            readInfo.append(e.attribute("sound", ""));
            readInfo.append(e.attribute("volume", ""));
            readInfo.append(e.attribute("set", ""));
            readInfo.append(e.attribute("reps1", ""));
            readInfo.append(e.attribute("reps2", ""));
            readInfo.append(e.attribute("reps3", ""));
            readInfo.append(e.attribute("currentReps", ""));
            readInfo.append(e.attribute("min", ""));
            readInfo.append(e.attribute("sec", ""));
            readInfo.append(e.attribute("calories", ""));

        }
      }
      n = n.nextSibling();
   }

    return readInfo;
}

void XML::saveDoneEx(QString group, QString name, QString kg, QString currentReps)
{
    QDate date = QDate::currentDate();
    QString dateString = date.toString("dd-MM-yyyy");

    QDomDocument doc( "Exercises" );
    QFile file( "/home/user/MyDocs/history.xml" );
    file.open( QIODevice::ReadOnly );
    doc.setContent( &file );


    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercise" )
    {
        root = doc.createElement( "exercise" );
        doc.appendChild( root );
    }

    file.close();

    root.appendChild(createHistoryNode(doc, group, name, dateString, kg, currentReps));

    if(!file.open(QIODevice::WriteOnly))
        return ;

    QTextStream ts( &file );
    ts << doc.toString();

    file.close();

    return ;

}

/*void XML::saveDoneEx(QString group, QString name, QString distance, QString min, QString sec)
{
    QDate date = QDate::currentDate();
    QString dateString = date.toString("ddMMyy");

    QDomDocument doc( "Exercises" );
    QFile file( "/home/user/MyDocs/history.xml" );
    file.open( QIODevice::ReadOnly );
    doc.setContent( &file );


    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercise" )
    {
        root = doc.createElement( "exercise" );
        doc.appendChild( root );
    }

    file.close();

    root.appendChild(createHistoryNode(doc, group, name, dateString, kg, currentReps));

    if(!file.open(QIODevice::WriteOnly))
        return ;

    QTextStream ts( &file );
    ts << doc.toString();

    file.close();

    return ;

}*/

QList<QString> XML::getDates()
{
    QList <QString> readInfo;

    QDomDocument doc( "Exercises" );
    QFile file( "/home/user/MyDocs/history.xml" );
    if( !file.open( QIODevice::ReadOnly ) )
    {
        return readInfo;
    }
    doc.setContent(&file);
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercise" )
    {
        return readInfo;
    }
    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
            if(!readInfo.isEmpty())
            {

                if(e.attribute("date", "") != readInfo.last())
                {
                    readInfo.append(e.attribute("date", ""));
                }
            }
            else
            {
                readInfo.append(e.attribute("date", ""));
            }
        }

      }


      n = n.nextSibling();
   }

    return readInfo;
}

QList < QList<QString> > XML::getHistoryByDate(QString date)
{
    QList< QList<QString> > list;
    QList <QString> readInfo;

    QDomDocument doc( "Exercises" );
    QFile file( "/home/user/MyDocs/history.xml" );
    if( !file.open( QIODevice::ReadOnly ) )
    {
        return list;
    }
    doc.setContent(&file);
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercise" )
    {
        return list;
    }
    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
            if(e.attribute("date", "")  == date)
            {
                readInfo.append(e.attribute("name", ""));
                readInfo.append(e.attribute("group", ""));
                readInfo.append(e.attribute("variable", ""));
                readInfo.append(e.attribute("reps", ""));
                list.append(readInfo);
                readInfo.clear();
            }
        }

      }


      n = n.nextSibling();
   }

    return list;
}

QList< QList<QString> > XML::readHistory()
{
    QList< QList<QString> > list;
    QList <QString> readInfo;

    QDomDocument doc( "Exercises" );
    QFile file( "/home/user/MyDocs/history.xml" );
    if( !file.open( QIODevice::ReadOnly ) )
    {
        return list;
    }
    doc.setContent(&file);
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercise" )
    {
        return list;
    }
    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
            readInfo.append(e.attribute("group", ""));
            readInfo.append(e.attribute("name", ""));
            readInfo.append(e.attribute("variable", ""));
            readInfo.append(e.attribute("date", ""));
            list.append(readInfo);
            readInfo.clear();
        }

      }


      n = n.nextSibling();
   }

    return list;
}

void XML::import(QString filename)
{
    QString name, group, muscle, info;

    QDomDocument doc( "Exercises" );
    QFile file(filename);
    file.open( QIODevice::ReadOnly );
    doc.setContent( &file );
    file.close();
    QDomElement root = doc.documentElement();


    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {

            name = e.attribute( "name", "" );
            group = e.attribute( "group", "" );
            muscle = e.attribute( "muscle", "" );
            info = e.attribute( "info", "" );
            saveEx(name,group,muscle,info);
        }
      }
      n = n.nextSibling();
   }
}

void XML::exportExercises(QModelIndexList name)
{
    QList <QString> list;
    QString group, muscle, info;
    QModelIndex tmp;

    QDomDocument doc( "Exercises" );
    QDomElement root = doc.createElement( "exercises" );
    doc.appendChild( root );

    while(!name.isEmpty())
    {
        tmp = name.takeFirst();
        list = openEx(tmp.data().toString());
        list.removeFirst();
        group = list.takeFirst();
        muscle = list.takeFirst();
        info = list.takeFirst();


        root.appendChild(createExerciseNode(doc, tmp.data().toString(), group, muscle, info));
    }
    QFile file( "/home/user/MyDocs/export.xml" );

    if(!file.open(QIODevice::WriteOnly))
        return;
    QTextStream ts( &file );
    ts << doc.toString();

   file.close();
   return;
}

void XML::saveEx(QString name, QString group, QString muscle,
                    QString info)
{
    QDomDocument doc( "Exercises" );
    QFile file( "/home/user/MyDocs/exercises.xml" );
    file.open( QIODevice::ReadOnly);
    doc.setContent( &file );

    file.close();

    //leta efter en vning med samma namn, isf ta bort den
    QDomElement root = doc.documentElement();

    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
            if(name == e.attribute( "name", "" ))
            {
                removeElement(name);
            }
        }
      }
      n = n.nextSibling();
   }

   QTextStream ts( &file );
   ts << doc.toString();
   doc.clear();

   file.open( QIODevice::ReadWrite );
   doc.setContent( &file );
   file.remove();
   root = doc.documentElement();
   if( root.tagName() != "exercises" )
   {
       root = doc.createElement( "exercises" );
       doc.appendChild( root );
   }
   file.close();

   root.appendChild(createExerciseNode(doc, name, group, muscle, info));

   if(!file.open(QIODevice::WriteOnly))
       return;
   ts << doc.toString();

   file.close();
   return;
}

void XML::saveCardio(QString name)
{

    QDomDocument doc( "Exercises" );
    QFile file( "/home/user/MyDocs/cardio.xml" );
    file.open( QIODevice::ReadOnly );
    doc.setContent( &file );

    file.close();


    //leta efter en vning med samma namn, isf ta bort den
    QDomElement root = doc.documentElement();


    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
            if(name == e.attribute( "name", "" ))
            {
                removeElement(name);
            }
        }
      }
      n = n.nextSibling();
   }
   QTextStream ts( &file );
   ts << doc.toString();

   doc.clear();
   file.open( QIODevice::ReadOnly );
   doc.setContent( &file );
   file.remove();
   root = doc.documentElement();
   if( root.tagName() != "exercises" )
   {
       root = doc.createElement( "exercises" );
       doc.appendChild( root );
   }
   file.close();

   root.appendChild(createCardioNode(doc, name));

   if(!file.open(QIODevice::WriteOnly))
       return;

   ts << doc.toString();

   file.close();
   return;
}

void XML::saveEatenFood(QString kcal, QString protein, QString carbohydrate, QString fat)
{
    QDate date = QDate::currentDate();
    QString dateString = date.toString("dd-MM-yyyy");

    QDomDocument doc( "Calories" );
    QFile file( "/home/user/MyDocs/calories.xml" );
    file.open( QIODevice::ReadOnly );
    doc.setContent( &file );


    QDomElement root = doc.documentElement();
    if( root.tagName() != "calorie" )
    {
        root = doc.createElement( "calorie" );
        doc.appendChild( root );
    }
    file.remove();
    file.close();

    root.appendChild(createCaloriesNode(doc, kcal, protein, carbohydrate, fat, dateString));

    if(!file.open(QIODevice::WriteOnly))
        return ;

    QTextStream ts( &file );
    ts << doc.toString();

    file.close();

    return ;
}

QList <int> XML::getTodaysCalories()
{
    QList <int> list;
    QDate date = QDate::currentDate();
    QString dateString = date.toString("dd-MM-yyyy");

    QString tmp;
    int kcal = 0, protein = 0, carbohydrate = 0, fat = 0;

    QDomDocument doc( "Calories" );
    QFile file( "/home/user/MyDocs/calories.xml" );
    if( !file.open( QIODevice::ReadOnly ) )
    {
      return list;
    }

    doc.setContent(&file);
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "calorie" )
    {
      return list;
    }

    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "calorie" )
        {
            if(dateString == e.attribute( "date", "" ))
            {
                tmp = e.attribute("kcal", "");
                kcal += tmp.toInt();

                tmp = e.attribute("protein", "");
                protein += tmp.toInt();

                tmp = e.attribute("carbohydrate", "");
                carbohydrate += tmp.toInt();

                tmp = e.attribute("fat", "");
                fat += tmp.toInt();
            }
        }
      }
      n = n.nextSibling();
   }

    list.append(kcal);
    list.append(protein);
    list.append(carbohydrate);
    list.append(fat);

    return list;

}

void XML::getMeanCalories()
{

}

QList <int> XML::getCaloriesByName(QString name)
{
    QList <int> list;
    QString readInfo;

    QDomDocument doc( "Ingredients" );
    QFile file( "/home/user/MyDocs/ingredients.xml" );

    if( !file.open( QIODevice::ReadOnly ) )
      return list;


    if( !doc.setContent( &file ) )
    {
      file.close();
      return list;
    }
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "ingredient" )
      return list;


    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "ingredient" )
        {
            if(name == e.attribute( "name", "" ))
            {
                readInfo = e.attribute("kcal", "");
                list.append(readInfo.toInt());
                readInfo = e.attribute("protein", "");
                list.append(readInfo.toInt());
                readInfo = e.attribute("carbohydrate", "");
                list.append(readInfo.toInt());
                readInfo = e.attribute("fat", "");
                list.append(readInfo.toInt());
                return list;
            }
        }
      }
      n = n.nextSibling();
   }
    return list;
}

void XML::saveFood(QString name, QString type, QString kcal, QString protein, QString carbohydrate, QString fat)
{

    QDomDocument doc( "Ingredients" );
    QFile file( "/home/user/MyDocs/ingredients.xml" );
    file.open( QIODevice::ReadOnly );
    doc.setContent( &file );
    file.close();

    //leta efter en vning med samma namn, isf ta bort den
    QDomElement root = doc.documentElement();


    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "ingredient" )
        {
            if(name == e.attribute( "name", "" ))
            {
                removeElement(name);
            }
        }
      }
      n = n.nextSibling();
   }
   QTextStream ts( &file );
   ts << doc.toString();

   doc.clear();

   file.open( QIODevice::ReadWrite );
   doc.setContent( &file );
   file.remove();

   root = doc.documentElement();
   if( root.tagName() != "ingredient" )
   {
       root = doc.createElement( "ingredient" );
       doc.appendChild( root );
   }
   file.close();

   root.appendChild(createFoodNode(doc, name, type, kcal, protein, carbohydrate, fat));

   if(!file.open(QIODevice::WriteOnly))
       return;

   ts << doc.toString();

   file.close();
   return;
}

void XML::updateLastWeight(QString name, QString weight, QString status, QString reps)
{
    QDomDocument doc( "Exercises" );
    QFile file( "/home/user/MyDocs/exercises.xml" );
    if( !file.open( QIODevice::ReadWrite ) )
      return;
    if( !doc.setContent( &file ) )
    {
      file.close();
      return;
    }
    file.remove();
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercises" )
      return;

    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
            if(name == e.attribute( "name", "" ))
            {
                if(reps == "Low")
                {
                    e.setAttribute("weight-low", weight);
                    e.setAttribute("status-low", status);
                }
                else if(reps == "Mid")
                {
                    e.setAttribute("weight-mid", weight);
                    e.setAttribute("status-mid", status);
                }
                else
                {
                    e.setAttribute("weight-high", weight);
                    e.setAttribute("status-high", status);
                }
            }
        }
      }
      n = n.nextSibling();
   }

    file.open( QIODevice::WriteOnly );
    QTextStream ts( &file );
    ts << doc.toString();
    file.close();

    return;
}

void XML::updateLastDistance(QString name, QString distance, QString min, QString sec, QString status)
{
    QDomDocument doc( "Cardio" );
    QFile file( "/home/user/MyDocs/cardio.xml" );
    if( !file.open( QIODevice::ReadWrite ) )
      return;
    if( !doc.setContent( &file ) )
    {
      file.close();
      return;
    }
    file.remove();
    file.close();
    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercises" )
      return;

    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
            if(name == e.attribute( "name", "" ))
            {
                e.setAttribute("distance", distance);
                e.setAttribute("min", min);
                e.setAttribute("sec", sec);
                e.setAttribute("status", status);
            }
        }
      }
      n = n.nextSibling();
   }

    file.open( QIODevice::ReadWrite );

    QTextStream ts( &file );
    ts << doc.toString();
    file.close();

    return;
}


QDomElement XML::createExerciseNode( QDomDocument &d, QString name, QString group, QString muscle,
                                QString info)
{
   QDomElement cn = d.createElement( "exercise" );

   cn.setAttribute( "name", name );
   cn.setAttribute( "group", group);
   cn.setAttribute( "muscle", muscle );
   cn.setAttribute( "info", info );
   cn.setAttribute( "weight-low", "0" );
   cn.setAttribute( "weight-mid", "0" );
   cn.setAttribute( "weight-high", "0" );
   cn.setAttribute( "status-low", "ok" );
   cn.setAttribute( "status-mid", "ok" );
   cn.setAttribute( "status-high", "ok" );

   return cn;
}

QDomElement XML::createCardioNode( QDomDocument &d, QString name)
{
   QDomElement cn = d.createElement( "exercise" );

   cn.setAttribute( "name", name );
   //cn.setAttribute( "group", group);
   cn.setAttribute( "distance", "0" );
   cn.setAttribute( "min", "0" );
   cn.setAttribute( "sec", "0" );
   cn.setAttribute( "status", "ok" );

   return cn;
}

QDomElement XML::createCaloriesNode( QDomDocument &d, QString kcal, QString protein, QString carbohydrate, QString fat, QString date)
{
   QDomElement cn = d.createElement( "calorie" );

   cn.setAttribute( "kcal", kcal );
   cn.setAttribute( "protein", protein );
   cn.setAttribute( "carbohydrate", carbohydrate );
   cn.setAttribute( "fat", fat );
   cn.setAttribute( "date", date );


   return cn;
}

QDomElement XML::createFoodNode( QDomDocument &d, QString name, QString type, QString kcal, QString protein, QString carbohydrate, QString fat)
{
   QDomElement cn = d.createElement( "ingredient" );

   cn.setAttribute( "name", name );
   cn.setAttribute( "type", type );
   cn.setAttribute( "kcal", kcal );
   cn.setAttribute( "protein", protein );
   cn.setAttribute( "carbohydrate", carbohydrate );
   cn.setAttribute( "fat", fat );

   return cn;
}

QDomElement XML::createHistoryNode( QDomDocument &d, QString group, QString name, QString date, QString kg, QString currentReps)
{
   QDomElement cn = d.createElement( "exercise" );

   cn.setAttribute("group", group);
   cn.setAttribute("name", name);
   cn.setAttribute("date", date);
   cn.setAttribute("variable", kg);
   cn.setAttribute("reps", currentReps);

   //set? reps?

   return cn;
}

QDomElement XML::createSettingsNode( QDomDocument &d, QString vibrate, QString sound, QString volume,
                                QString set, QString reps1, QString reps2, QString reps3, QString currentReps,
                                QString min, QString sec, QString calories)
{
   QDomElement cn = d.createElement( "settings" );

   cn.setAttribute( "vibrate", vibrate );
   cn.setAttribute("sound", sound);
   cn.setAttribute("volume", volume);
   cn.setAttribute( "set", set );
   cn.setAttribute( "reps1", reps1 );
   cn.setAttribute( "reps2", reps2 );
   cn.setAttribute( "reps3", reps3 );
   cn.setAttribute( "currentReps", currentReps );
   cn.setAttribute( "min", min );
   cn.setAttribute( "sec", sec );
   cn.setAttribute( "calories", calories );

   return cn;
}

QList<QString> XML::openEx(QString name)
{
    QList<QString> readInfo;

    QDomDocument doc( "Exercises" );
    QFile file( "/home/user/MyDocs/exercises.xml" );

    if( !file.open( QIODevice::ReadOnly ) )
      return readInfo;



    if( !doc.setContent( &file ) )
    {
      file.close();
      return readInfo;
    }
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercises" )
      return readInfo;



    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
            if(name == e.attribute( "name", "" ))
            {

                readInfo.clear();
                readInfo.append(name);
                readInfo.append(e.attribute("group", ""));
                readInfo.append(e.attribute("muscle", ""));
                readInfo.append(e.attribute("info", ""));
                readInfo.append(e.attribute("weight-low", ""));
                readInfo.append(e.attribute("weight-mid", ""));
                readInfo.append(e.attribute("weight-high", ""));
                readInfo.append(e.attribute("status-low", ""));
                readInfo.append(e.attribute("status-mid", ""));
                readInfo.append(e.attribute("status-high", ""));
            }
        }
      }
      n = n.nextSibling();
   }

    return readInfo;
}

QList<QString> XML::openCardio(QString name)
{
    QList<QString> readInfo;

    QDomDocument doc( "Exercises" );
    QFile file( "/home/user/MyDocs/cardio.xml" );

    if( !file.open( QIODevice::ReadOnly ) )
      return readInfo;


    if( !doc.setContent( &file ) )
    {
      file.close();
      return readInfo;
    }
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercises" )
      return readInfo;


    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
            if(name == e.attribute( "name", "" ))
            {

                readInfo.clear();
                readInfo.append(name);
                //readInfo.append(e.attribute("group", ""));
                readInfo.append(e.attribute("distance", ""));
                readInfo.append(e.attribute("min", ""));
                readInfo.append(e.attribute("sec", ""));
                readInfo.append(e.attribute("status", ""));
            }
        }
      }
      n = n.nextSibling();
   }
    return readInfo;
}

QList<QString> XML::openGroup(QString group)
{
    QList<QString> readInfo;
    readInfo.clear();

    QDomDocument doc( "Exercises" );
    QFile file( "/home/user/MyDocs/exercises.xml" );

    if( !file.open( QIODevice::ReadOnly ) )
    {
        readInfo.append("file");
      return readInfo;
    }

    doc.setContent(&file);
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercises" )
    {
        readInfo.append(root.tagName());
      return readInfo;
    }

    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
          if(group == e.attribute( "group", ""))
          {

              readInfo.append(e.attribute("name", ""));
          }
        }
      }
      n = n.nextSibling();
   }
    return readInfo;
}

QList<QString> XML::openIngredients()
{
    QList<QString> readInfo;
    readInfo.clear();

    QDomDocument doc( "Ingredients" );
    QFile file( "/home/user/MyDocs/ingredients.xml" );

    if( !file.open( QIODevice::ReadOnly ) )
    {
        return readInfo;
    }

    doc.setContent(&file);
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "ingredient" )
    {
        readInfo.append(root.tagName());
        return readInfo;
    }

    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "ingredient" )
        {
            readInfo.append(e.attribute("name", ""));
        }
      }
      n = n.nextSibling();
   }
    return readInfo;
}

QList<QString> XML::openCardio()
{
    QList<QString> readInfo;
    readInfo.clear();

    QDomDocument doc( "Cardio" );
    QFile file( "/home/user/MyDocs/cardio.xml" );

    if( !file.open( QIODevice::ReadOnly ) )
    {
        readInfo.append("file");
        return readInfo;
    }

    doc.setContent(&file);
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercises" )
    {
        readInfo.append(root.tagName());
      return readInfo;
    }

    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
          readInfo.append(e.attribute("name", ""));
        }
      }
      n = n.nextSibling();
   }
    return readInfo;
}

QList<QString> XML::openAll()
{
    QList<QString> readInfo;
    readInfo.clear();

    QDomDocument doc( "Exercises" );
    QFile file( "/home/user/MyDocs/exercises.xml" );
    if( !file.open( QIODevice::ReadOnly ) )
    {
        readInfo.append("file");
      return readInfo;
    }

    doc.setContent(&file);
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "exercises" )
    {
        readInfo.append(root.tagName());
      return readInfo;
    }

    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      QDomElement e = n.toElement();
      if( !e.isNull() )
      {
        if( e.tagName() == "exercise" )
        {
          readInfo.append(e.attribute("name", ""));
        }
      }
      n = n.nextSibling();
   }
    return readInfo;
}
