#include "startwindow.h"

StartWindow::StartWindow(QWidget *parent) :
    QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5PortraitOrientation, true);//WA_Maemo5AutoOrientation
    setAttribute(Qt::WA_Maemo5StackedWindow);

    QWidget *widget = new QWidget;
    setCentralWidget(widget);

    fw = new FoodWindow(this);
    fw->hide();
    niw = new NewIngredientWindow(this);
    niw->hide();
    hw = new HistoryWindow(this);
    hw->hide();
    ww = new WeightWindow(this);
    ww->hide();
    sw = new SettingsWindow(this);
    sw->hide();
    nw = new NewExerciseWindow(this);
    nw->hide();
    npw = new NewProgramWindow(this);
    npw->hide();
    lw = new ListWindow(this);

    xml = new XML();

    QVBoxLayout *vLayout = new QVBoxLayout;
    QHBoxLayout *hLabelLayout = new QHBoxLayout;
    lblWeight = new QLabel("Weight-lift/week \n 1050kg \n 3 times/week");
    lblCardio = new QLabel("Cardio/week \n 325km \n 5 times/week");

    lblWeight->setAlignment(Qt::AlignCenter);
    lblCardio->setAlignment(Qt::AlignCenter);

    hLabelLayout->addWidget(lblWeight);
    hLabelLayout->addWidget(lblCardio);

    QHBoxLayout *hButtonLayout = new QHBoxLayout;
    btnWeight = new QPushButton("Weight-lifting");
    connect(btnWeight,SIGNAL(clicked()),this,SLOT(showWeight()));

    btnCardio = new QPushButton("Cardio");
    connect(btnCardio,SIGNAL(clicked()),this,SLOT(showCardio()));
    btnProgram = new QPushButton("Program");

    btnFood = new QPushButton("Food");
    connect(btnFood,SIGNAL(clicked()),this, SLOT(showFood()));

    hButtonLayout->addWidget(btnWeight);
    hButtonLayout->addWidget(btnCardio);
    hButtonLayout->addWidget(btnProgram);
    hButtonLayout->addWidget(btnFood);

    vLayout->addLayout(hLabelLayout);
    vLayout->addLayout(hButtonLayout);

    widget->setLayout(vLayout);

    createActions();
    createMenu();

    checkIfFirstTime();

    QList <QString> tmp = getStats();
    if(!tmp.isEmpty())
    {
        lblWeight->setText("Weight-lift/week \n " + tmp.takeFirst() + "kg \n "+ tmp.takeFirst() + "times in total");
        lblCardio->setText("Cardio/week \n" + tmp.takeFirst() + "km \n" + tmp.takeFirst() + "times in total");
    }

    resize(480,720);
}

QList <QString> StartWindow::getStats()
{
    QList < QList <QString> > list;
    QList <QString> tmp, stats;
    double km = 0;
    int countW = 0, countC = 0, kg = 0;
    QString strKg, strKm, strCountW, strCountC;

    list = xml->readHistory();
    while(!list.isEmpty())
    {
        tmp = list.takeFirst();

        if(tmp.takeFirst() == "Cardio")
        {
            tmp.removeFirst();
            km += tmp.takeFirst().toDouble();
            countC++;
        }
        else
        {
            tmp.removeFirst();
            kg += tmp.takeFirst().toInt();
            countW++;
        }
    }

    strKg.setNum(kg);
    strKm.setNum(km);
    strCountW.setNum(countW);
    strCountC.setNum(countC);

    stats.append(strKg);
    stats.append(strCountW);
    stats.append(strKm);
    stats.append(strCountC);

    return stats;

}

StartWindow::~StartWindow()
{

}

void StartWindow::checkIfFirstTime()
{
    QFile file;
    if(!file.exists("/home/user/MyDocs/exercises.xml"))
        xml->saveEx("Example","Arms","Biceps","Some info here");

    if(!file.exists("/home/user/MyDocs/cardio.xml"))
        xml->saveCardio("Cardio");

    //if(!file.exists("/home/user/MyDocs/history.xml"))
        //return true;
    //if(!file.exists("/home/user/MyDocs/program.xml"))
        //return true;

    if(!file.exists("/home/user/MyDocs/settings.xml"))
        xml->saveSettings("0","0","0","1","1","1","1","Low","1","0","2500");

}
void StartWindow::changeEvent(QEvent *event)
{
    if(event->type() == QEvent::ActivationChange)
    {
        QList <QString> tmp = getStats();

        if(!tmp.isEmpty())
        {
            lblWeight->setText("Weight-lift/week \n " + tmp.takeFirst() + "kg \n "+ tmp.takeFirst() + "times in total");
            lblCardio->setText("Cardio/week \n" + tmp.takeFirst() + "km \n" + tmp.takeFirst() + "times in total");
        }
    }
}

void StartWindow::showNewIngredient()
{
    niw->load();
    niw->show();
}

void StartWindow::showHistory()
{
    hw->load();
    hw->show();
}

void StartWindow::showFood()
{
    fw->load();
    fw->show();

}

void StartWindow::showWeight()
{
    ww->show();
}

void StartWindow::showCardio()
{
    lw->loadExercises("Cardio");
    lw->show();
}

void StartWindow::showSettings()
{
    sw->load();
    sw->show();
}

void StartWindow::showNewExercise()
{
    nw->load();
    nw->show();
}

void StartWindow::showNewProgram()
{
    npw->show();
}

void StartWindow::createMenu()
{
    QMenu *menu;
    menu = menuBar()->addMenu(tr("&Menu"));
    menu->addAction(historyAction);
    menu->addAction(settingsAction);
    menu->addAction(newExerciseAction);
    menu->addAction(newProgramAction);
    menu->addAction(newIngredientAction);
}

void StartWindow::createActions()
{
    historyAction = new QAction("History",this);
    settingsAction = new QAction("Settings",this);
    newExerciseAction = new QAction("New Exercise",this);
    newProgramAction = new QAction("New program",this);
    newIngredientAction = new QAction("New Ingredient",this);

    connect(historyAction, SIGNAL(triggered()), this, SLOT(showHistory()));
    connect(settingsAction, SIGNAL(triggered()), this, SLOT(showSettings()));
    connect(newExerciseAction, SIGNAL(triggered()), this, SLOT(showNewExercise()));
    connect(newProgramAction, SIGNAL(triggered()), this, SLOT(showNewProgram()));
    connect(newIngredientAction, SIGNAL(triggered()), this, SLOT(showNewIngredient()));
}
