#ifndef LISTWINDOW_H
#define LISTWINDOW_H

#include <QMainWindow>
#include <QtGui>
#include "infowindow.h"
#include "infomotionwindow.h"
#include "xml.h"
#include "newingredientwindow.h"
#include "historywindow.h"
#include <QMaemo5EditBar>

class ListWindow : public QMainWindow
{
    Q_OBJECT
public:
    explicit ListWindow(QWidget *parent = 0);
    void loadExercises(QString group);
    void loadDate(QString date);

signals:

public slots:

private:
    XML *xml;
    HistoryWindow *hw;
    InfoWindow *iw;
    InfoMotionWindow *imw;
    SettingsWindow *sw;
    NewExerciseWindow *nw;
    NewProgramWindow *npw;
    NewIngredientWindow *niw;

    void createActions();
    void createMenu();

    QMaemo5EditBar *editBar;

    QAction *settingsAction;
    QAction *newExerciseAction;
    QAction *newProgramAction;
    QAction *exportAction;
    QAction *newIngredientAction;
    QAction *historyAction;

    QListView *lstExercises;
    QStandardItemModel *model;

    QList < QList <QString> > exercises;

    QString group;

private slots:
    void showInfo(QModelIndex index);
    void showSettings();
    void showNewExercise();
    void showNewProgram();
    void deleteItem();
    void editItem();
    void showContextMenuForWidget(const QPoint &pos);
    void showNewIngredient();
    void showHistory();
    void import();

};

#endif // LISTWINDOW_H
