#include "listwindow.h"
#include <QtGui>
#include <QtDebug>

ListWindow::ListWindow(QWidget *parent) :
    QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);

    iw = new InfoWindow(this);
    iw->hide();
    niw = new NewIngredientWindow(this);
    niw->hide();
    imw = new InfoMotionWindow(this);
    imw->hide();
    sw = new SettingsWindow(this);
    sw->hide();
    nw = new NewExerciseWindow(this);
    nw->hide();
    npw = new NewProgramWindow(this);
    npw->hide();
    hw = new HistoryWindow(this);
    hw->hide();
    xml = new XML();

    editBar = new QMaemo5EditBar(this);


    model = new QStandardItemModel(this);

    lstExercises = new QListView();
    lstExercises->setModel(model);

    connect(lstExercises,SIGNAL(clicked(QModelIndex)),this,SLOT(showInfo(QModelIndex)));
    lstExercises->setContextMenuPolicy(Qt::CustomContextMenu);
    connect(lstExercises, SIGNAL(customContextMenuRequested(const QPoint &)),SLOT(showContextMenuForWidget(const QPoint &)));

    createActions();
    createMenu();

    setCentralWidget(lstExercises);
}

void ListWindow::loadExercises(QString grp)
{
    QList <QString> list;
    group = grp;
    if(grp == "Cardio")
        list = xml->openCardio();
    else
        list = xml->openGroup(grp);

    model->clear();
    lstExercises->setSelectionMode(QListView::SingleSelection);
    if(list.isEmpty())
    {
        model->appendRow(new QStandardItem ("No exercises"));
        lstExercises->setSelectionMode(QListView::NoSelection);
        return;
    }

    while(!list.isEmpty())
    {
        model->appendRow(new QStandardItem(list.takeFirst()));
    }

    model->sort(0);
}

void ListWindow::loadDate(QString date)
{
    QList <QString> tmp;
    QString name, grp, reps, var;

    lstExercises->setSelectionMode(QListView::NoSelection);
    setWindowTitle(date);
    model->clear();
    exercises = xml->getHistoryByDate(date);

    while(!exercises.isEmpty())
    {
        tmp = exercises.takeFirst();
        name = tmp.takeFirst();
        grp = tmp.takeFirst();
        var = tmp.takeFirst();
        reps = tmp.takeFirst();

        if(grp != "Cardio")
            model->appendRow(new QStandardItem(grp + "/" + name + ": " + var + "Kg - " + reps + " reps"));
        else
            model->appendRow(new QStandardItem(grp + "/" + name + ": " + var + "Km" + " - " + reps));
    }
}

void ListWindow::showNewIngredient()
{
    niw->load();
    niw->show();
}
void ListWindow::showInfo(QModelIndex index)
{
    setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
    if(index.data().toString() == "No exercises")
        return;
    if(group !=  "Cardio")
    {
        iw->loadExercise(index.data().toString());
        iw->show();
    }
    else
    {
        imw->loadMotionExercise(index.data().toString());
        imw->show();
    }
}

void ListWindow::showSettings()
{
    sw->load();
    sw->show();
}

void ListWindow::showHistory()
{
    hw->load();
    hw->show();
}

void ListWindow::showNewExercise()
{
    nw->load();
    nw->show();
}

void ListWindow::showNewProgram()
{
    npw->show();
}

void ListWindow::createMenu()
{
    QMenu *menu;
    menu = menuBar()->addMenu(tr("&Menu"));
    menu->addAction(historyAction);
    menu->addAction(settingsAction);
    menu->addAction(newExerciseAction);
    menu->addAction(newProgramAction);
    menu->addAction(newIngredientAction);
    menu->addAction(exportAction);
}

void ListWindow::createActions()
{
    historyAction = new QAction("History",this);
    settingsAction = new QAction("Settings",this);
    newExerciseAction = new QAction("New Exercise",this);
    newProgramAction = new QAction("New program",this);
    newIngredientAction = new QAction("New Ingredient",this);
    exportAction = new QAction("Export exercises",this);

    connect(historyAction, SIGNAL(triggered()), this, SLOT(showHistory()));
    connect(settingsAction, SIGNAL(triggered()), this, SLOT(showSettings()));
    connect(newExerciseAction, SIGNAL(triggered()), this, SLOT(showNewExercise()));
    connect(newProgramAction, SIGNAL(triggered()), this, SLOT(showNewProgram()));
    connect(newIngredientAction, SIGNAL(triggered()), this, SLOT(showNewIngredient()));
    connect(exportAction,SIGNAL(triggered()),this, SLOT(import()));


}

void ListWindow::showContextMenuForWidget(const QPoint &pos)
{

    QMenu contextMenu(this);
    QAction *editItemAction = new QAction("Edit", this);
    QAction *deleteItemAction = new QAction("Remove", this);

    connect(editItemAction, SIGNAL(triggered()), this, SLOT(editItem()));
    connect(deleteItemAction, SIGNAL(triggered()), this, SLOT(deleteItem()));
    contextMenu.addAction(editItemAction);
    contextMenu.addAction(deleteItemAction);
    contextMenu.exec(mapToGlobal(pos));
}

void ListWindow::deleteItem()
{
    QString str;

    str = lstExercises->currentIndex().data().toString();

    for(int i = 0; i < model->rowCount();i++)
    {
        if(model->index(i,0).data().toString() == str)
            model->removeRow(i);
    }

    xml->removeElement(str);
}

void ListWindow::editItem()
{
    QString str;
    QList <QString> list;
    str = lstExercises->currentIndex().data().toString();

    list = xml->openEx(str);
    nw->load(list.takeFirst(),list.takeFirst(),list.takeFirst(),list.takeFirst());
    nw->show();
}


void ListWindow::import()
{
    QString s = QFileDialog::getOpenFileName(this,"Choose a file","/home/user/MyDocs","XML files (*.xml)");
    qDebug() << s;
    xml->import(s);
}
