/*
 * Copyright (C) 2016 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef JAVASCRIPTPLUGINGLOBALOBJECT_H
#define JAVASCRIPTPLUGINGLOBALOBJECT_H

#include <QObject>
#include <QPointer>
#include <QScriptEngine>

class QNetworkAccessManager;

class JavaScriptPluginGlobalObject : public QObject
{
    Q_OBJECT

public:
    explicit JavaScriptPluginGlobalObject(QScriptEngine *engine);
    
    void setNetworkAccessManager(QNetworkAccessManager *manager);

public Q_SLOTS:
    QString atob(const QString &ascii) const;
    QString btoa(const QString &binary) const;

    void clearInterval(int timerId);
    void clearTimeout(int timerId);

    void setInterval(const QScriptValue &function, int msecs);
    void setTimeout(const QScriptValue &function, int msecs);

protected:
    QPointer<QScriptEngine> m_engine;

private:
    static QScriptValue newXMLHttpRequest(QScriptContext *context, QScriptEngine *engine);
    
    QNetworkAccessManager* networkAccessManager();
        
    bool callFunction(QScriptValue function) const;
        
    virtual void timerEvent(QTimerEvent *event);
    
    QPointer<QNetworkAccessManager> m_nam;
    
    QHash<int, QScriptValue> m_intervals;
    QHash<int, QScriptValue> m_timeouts;
};

#endif // JAVASCRIPTPLUGINGLOBALOBJECT_H
