#include "retrieveurlsdialog.h"
#include "../shared/urlretriever.h"
#include "../shared/settings.h"
#include "../shared/database.h"
#include <QTextEdit>
#include <QDialogButtonBox>
#include <QPushButton>
#include <QHBoxLayout>
#include <QFile>

RetrieveUrlsDialog::RetrieveUrlsDialog(QWidget *parent) :
    QDialog(parent),
    m_urlsEdit(new QTextEdit(this)),
    m_buttonBox(new QDialogButtonBox(QDialogButtonBox::Ok, Qt::Vertical, this))
{
    this->setWindowTitle(tr("Retrieve URLs"));
    this->setAttribute(Qt::WA_DeleteOnClose, true);

    QHBoxLayout *hbox = new QHBoxLayout(this);
    hbox->addWidget(m_urlsEdit);
    hbox->addWidget(m_buttonBox);

    this->connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(parseUrls()));
}

RetrieveUrlsDialog::~RetrieveUrlsDialog() {}

QString RetrieveUrlsDialog::text() const {
    return m_urlsEdit->toPlainText();
}

void RetrieveUrlsDialog::setText(const QString &text) {
    m_urlsEdit->setText(text);
}

void RetrieveUrlsDialog::parseUrlsFromTextFile(const QString &fileName) {
    QFile file(fileName);

    if (file.open(QIODevice::ReadOnly | QIODevice::Text)) {
        while (!file.atEnd()) {
            QUrl url(file.readLine());

            if (url.isValid()) {
                m_urlsEdit->insertPlainText(url.toString());
            }
        }

        file.close();
    }
}

void RetrieveUrlsDialog::onTextChanged() {
    m_buttonBox->button(QDialogButtonBox::Ok)->setEnabled(!m_urlsEdit->toPlainText().isEmpty());
}

void RetrieveUrlsDialog::parseUrls() {
    UrlRetriever::instance()->parseUrlsFromText(m_urlsEdit->toPlainText());
    this->accept();
}
