#include "packagetransferdelegate.h"
#include "../shared/transfer.h"
#include "../shared/definitions.h"
#include <QApplication>
#include <QStyleOptionProgressBar>
#include <QPainter>

PackageTransferDelegate::PackageTransferDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void PackageTransferDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    QStyledItemDelegate::paint(painter, option, index);
    QImage icon(index.data(Transfer::IconRole).toString());

    if (icon.isNull()) {
        icon = QImage(ICON_PATH + "qdl.png");
    }

    painter->drawImage(option.rect.left() + 8, option.rect.top() + 25, icon.scaled(36, 36, Qt::IgnoreAspectRatio, Qt::SmoothTransformation));

    QRect textRect(option.rect.left() + 52, option.rect.top(), option.rect.width() - 218, option.rect.height());

    painter->setClipRect(textRect);
    painter->drawText(textRect, Qt::TextSingleLine | Qt::AlignVCenter, index.data(Transfer::NameRole).toString());
    painter->setClipping(false);

    int progress = index.data(Transfer::ProgressRole).toInt();

    QStyleOptionProgressBar progressBar;
    progressBar.rect = option.rect;
    progressBar.rect.setTop(option.rect.top() + 8);
    progressBar.rect.setHeight(70);
    progressBar.rect.setLeft(option.rect.right() - 158);
    progressBar.rect.setWidth(150);
    progressBar.minimum = 0;
    progressBar.maximum = 100;
    progressBar.progress = progress;
    progressBar.textVisible = true;
    progressBar.text = QString::number(progress) + "%";

    QApplication::style()->drawControl(QStyle::CE_ProgressBar, &progressBar, painter);
}

QSize PackageTransferDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 86);
}
