#ifndef NETWORKPROXYDIALOG_H
#define NETWORKPROXYDIALOG_H

#include <QDialog>

class QCheckBox;
class QLineEdit;
class ValueSelector;

class NetworkProxyDialog : public QDialog
{
    Q_OBJECT

public:
    explicit NetworkProxyDialog(QWidget *parent = 0);
    ~NetworkProxyDialog();

private:
    void loadSettings();

private slots:
    void saveSettings();
    void onProxyCheckboxToggled(bool checked);
    
private:
    QCheckBox *m_proxyCheckbox;
    QWidget *m_proxyWidget;
    ValueSelector *m_proxyTypeSelector;
    QLineEdit *m_hostEdit;
    QLineEdit *m_portEdit;
    QLineEdit *m_userEdit;
    QLineEdit *m_passEdit;
};

#endif // NETWORKPROXYDIALOG_H
