#ifndef EDITDECAPTCHAACCOUNTDIALOG_H
#define EDITDECAPTCHAACCOUNTDIALOG_H

#include <QDialog>

class QLineEdit;
class QLabel;
class QPushButton;
class QCheckBox;

class EditDecaptchaAccountDialog : public QDialog
{
    Q_OBJECT

public:
    explicit EditDecaptchaAccountDialog(QWidget *parent = 0);
    ~EditDecaptchaAccountDialog();

    void setAccount(const QString &icon, const QString &serviceName, const QString &username, const QString &password);

private slots:
    void onAccountTextChanged();
    void onActiveChanged(bool active);
    void submitAccount();

signals:
    void addAccount(const QString &serviceName, const QString &username, const QString &password);

private:
    QLabel *m_iconLabel;
    QLabel *m_nameLabel;
    QLineEdit *m_userEdit;
    QLineEdit *m_passEdit;
    QCheckBox *m_activeCheckbox;
    QPushButton *m_doneButton;
};

#endif // EDITDECAPTCHAACCOUNTDIALOG_H
